<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
    <!-- CSRF Token -->
    <script src="https://cdn.jsdelivr.net/npm/jquery@3.6.3/dist/jquery.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert.min.css">

    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title>Profit Loss Sheet</title>

   
    <style type="text/css">
      th,td{
            font-size: 9px;
            text-align: center;
  
      }
      .th1{
        background: #2543c1db;
      color: #fff;
          border: 1px solid;
  
      }
      .th2{
            background:#086504;
      color: #fff;
          border: 1px solid;
  
      }
       .th3{
            background: #b5651d;
      color: #fff;
          border: 1px solid;
  
      }
      .tdlightblue {
      background: lightblue;
          border: 1px solid;
          border-top: 1px dotted #c3b3b3 !important;
      border-bottom: 1px dotted #af9292 !important;
  
  }
  
      .tdblue {
      background: #1c992ad6;
      color: #fff;
          border: 1px solid #333;
          border-top: 1px dotted #c3b3b3 !important;
      border-bottom: 1px dotted #af9292 !important;
  
  }
  
     .tdstate {
  
          border: 2px solid #333;
          color: red;
          font-weight: bold;
          border-top: 1px dotted #c3b3b3 !important;
      border-bottom: 1px dotted #af9292 !important;
  
  }
  
  .tdlightgreen{
        background: lightgreen;
      border: 1px solid;
      border-top: 1px dotted #c3b3b3 !important;
      border-bottom: 1px dotted #af9292 !important;
  }
  .tdlightbrown{
        background: #e8720878;
      border: 1px solid;
      border-top: 1px dotted #c3b3b3 !important;
      border-bottom: 1px dotted #af9292 !important;
  }
  
  .tabfedex{
          background: #ffc1075e;
      border: 1px solid;
      border-top: 1px dotted #c3b3b3 !important;
      border-bottom: 1px dotted #af9292 !important;
  }
  input {margin-bottom: 5px; padding: 2px 3px; width: 209px !important; 
  }
  
    </style>
</head>
<body>
  <nav class="navbar navbar-light bg-light">
    <div class="container-fluid">
      <a class="navbar-brand">Profit Loss</a>
      <?php
        $companyPrefix = auth()->user()->company->companyPrefix;
      ?>
      <form method="GET" action=""> 
        <div class="row ">

       
      
          
          <div class="col-1">
            <span style="margin-top: 7px;
            position: absolute;
            margin-left: -6px;
            font-weight: bold;"><?php echo e($companyPrefix); ?> </span>
          </div>
            <div class="col-5">
              <input type="text" name="sonumber" class="form-control" value="<?php echo e(request()->get('sonumber')); ?>">
                </div>
                
            <div class="col-4">
                <button type="submit" class="btn btn-primary waves-effect waves-light">Show</button>
                <?php if(request()->get('sonumber')): ?>

                <a href="<?php echo e(route('profit-loss-sheet')); ?>" class="waves-effect waves-light">Reset</a>
                <?php endif; ?>
            </div>
            <div class="col-2">
                
            </div>
        </div>
        </form>
      <form method="GET" action=""> 
        <div class="row ">

            <?php if(request()->get('onlysheet')): ?>
            <input type="hidden" value="<?php echo e(request()->get('onlysheet')); ?>" name="onlysheet" />
          <?php endif; ?>
          <div class="col-3">
            <?php
            $onlysheet = [0 => 'All', 1 => 'Commercial' , 2 => 'GSA' , 3 => 'Bidding' , 4 => 'Amazon' , 5 => 'NA' , 6 => 'Open Market'];  
            ?>
            <fieldset class="form-group">
              <select class="form-control" name="onlysheet" > 
                <?php $__currentLoopData = $onlysheet; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $sheet): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($key); ?>" <?php if(request()->get('onlysheet') == $key): ?> selected <?php endif; ?>><?php echo e($sheet); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                
               </select>
            </fieldset>
          </div>
            <div class="col-4">
                <fieldset class="form-group">
                    <select class="form-control" name="dealMonth" id="dealMonth" onchange="showAllYearButton()">
                        <!-- <option value="all" selected="">All</option> -->
                <option value="all" <?php if($dealMonth == 'all'): ?> selected=""  <?php endif; ?> >All</option>

                        <?php $__currentLoopData = $dealMonthArray; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $dm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      

                    <option value="<?php echo e($key); ?>" <?php if($dealMonth == $key): ?> selected=""  <?php endif; ?> ><?php echo e($dm); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </fieldset>
                </div>
                <div class="col-3">
                <fieldset class="form-group">
                    <select class="form-control" name="dealYear" id="dealYear">
                    <?php $__currentLoopData = $dealYearArray; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $dy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($key); ?>" <?php if($dealYear == $key): ?> selected="" <?php elseif($key == date("y")): ?> selected="" <?php endif; ?> ><?php echo e($dy); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </fieldset>
            </div>
            <div class="col-2">
                <button type="submit" class="btn btn-primary waves-effect waves-light" id="submit-form">Show</button>
                <button type="button" class="btn btn-primary waves-effect waves-light" id="button-form" onclick="requestYearlyReport()" style="display: none
                ">Show</button>
            </div>
        </div>
        </form>
    </div>
  </nav>
    <div id="app" >

      <p id="month-progess" style="text-align:center; color: darkcyan;font-weight: 700;"></p>
      
<?php

$grosssale = [];
$salefrieght = [];
$saletax = [];
$cccharges = [];
$netamount = [];
$pototalamount = [];
$grossprofit = [];
?>
   
      <table class="table table-responsive-xl">
        <thead>
          <tr>
            <th></th>
            <th></th>
            <th></th>
            <th></th>
            <th></th>
            <th></th>
            <th></th>
            <th></th>
            <th id="gross-sale">$0.00</th>
            
            <th id="sale-frieght">$0.00</th>
            <th id="sale-tax">$0.00</th>
            <th id="order-total"></th>
            
            <th id="cc-charges">$0.00</th>
            <th id="net-amount">$0.00</th>
            <th></th>
            <th></th>
            <th></th>
            <th></th>
        
            <th id="po-total-amount">$0.00</th>
            <th></th>
       
      
            <th id="gross-profit">Total: $0.00</th>
          </tr>
          <tr>
            <th>#</th>
            <th class="th1">MONTH</th>
            <th class="th1">ORDER SOURCE</th>
           
         
            <th class="th1">INVOICE NO.</th>
            <th class="th1">INVOICE DATE</th>
            <th class="th1">P.O. NO. / REF. NO.</th>
            <th class="th1">CUSTOMER</th>
            <th class="th1">STATE</th>
            <th class="th1">GROSS SALE AMOUNT</th>
            
            <th class="th1">FREIGHT</th>
            <th class="th1">TAX</th>
            <th class="th1"> ORDER TOTAL</th>
            
            <th class="th1">CC / AMAZON</th>
            <th class="th1">NET SALE AMOUNT</th>
            <th class="th2">P.O. NO.</th>
            <th class="th2">VENDOR</th>
            <th class="th2">VENDOR INVOICE NO.</th>
            <th class="th2">INVOICE DATE</th>
       
            <th class="th2">INVOICE AMOUNT</th>
     
            <th class="" style="background:#9b9b9b;">TRACKING NO.</th>
            <th class="th3">GROSS PROFIT</th>
          </tr>
        </thead>
        <tbody id="myTable">
          <?php $__currentLoopData = $all_records; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kewy => $single_record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
     
          <?php


$grosssale[] = $single_record['gross_sale'] ? $single_record['gross_sale'] : 0;
$salefrieght[] = $single_record['frieght'] ? $single_record['frieght'] : 0;
$saletax[] = $single_record['tax'] ? $single_record['tax'] : 0;
$cccharges[] = $single_record['cc_amazon'] ? $single_record['cc_amazon'] : 0;


          ?>


          <tr>
           
            <td><?php echo e($kewy+1); ?></td>
           
            <td ><?php if($single_record['invoice']): ?><a href="javascript:void(0)" data-toggle="modal" data-target="#myModal-<?php echo e($single_record['invoice']); ?>"><?php echo e($single_record['month'] ? $single_record['month'] : '-'); ?> </a>
              <?php echo $__env->make('reports.profit-loss.date-option', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
              
              <?php endif; ?></td>
            <?php
            $single_recordthetype = $single_record['thetype'];
              $selctoption = $departments[$single_recordthetype] ?? null;
              $single_record_invoice = $single_record['invoice'];
              $invoiceId = $single_record['invoiceId'];
            ?> 
            <td ><a href="javascript:void(0)" id="show-dept-<?php echo e($invoiceId); ?>" onclick="showHideDept(<?php echo e($invoiceId); ?>, 1)"><?php echo e($selctoption); ?></a> 
              <br> 
              <select style="display:none" id="selected-dept-<?php echo e($invoiceId); ?>" onchange="changeDept(<?php echo e($invoiceId); ?>)"> 
                <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                
                <option value="<?php echo e($key); ?>"><?php echo e($department); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> </select><br> 
                <a href="javascript:void(0)" style="display:none" id="hide-dept-<?php echo e($invoiceId); ?>" onclick="showHideDept('<?php echo e($invoiceId); ?>', 0)">cancel</a>
              </td>

            
            <td ><?php echo e($single_record['invoice'] ? $single_record['invoice'] : '-'); ?></td>
            <td ><?php echo e($single_record['invoice_date'] ? $single_record['invoice_date'] : '-'); ?></td>
            <td ><?php echo e($single_record['reference'] ? $single_record['reference'] : '-'); ?> </td>
            <td ><?php echo e($single_record['customer'] ? $single_record['customer'] : '-'); ?> </td>
            <td class="tdstate"><?php echo e($single_record['state'] ? $single_record['state'] : '-'); ?> </td>
            <td class="tdlightblue grosssalesmount"><?php echo e($single_record['gross_sale'] ? $single_record['gross_sale'] : '-'); ?> </td>
            
            <td class="tdlightblue frieghtamount"> <?php echo e($single_record['frieght'] ? $single_record['frieght'] : '-'); ?></td>
            <td class="tdlightblue salestaxth"><?php echo e($single_record['tax'] ? $single_record['tax'] : '-'); ?></td>
            <td class="tdlightgreen grosssale"> <?php echo e($single_record['invoice_total'] ? $single_record['invoice_total'] : '-'); ?></td>
            
        
            <td class="tdlightblue cccharges">
              
              <!-- The Modal -->
<div class="modal" id="cc_amazonModal<?php echo e($invoiceId); ?>">
  <div class="modal-dialog">
    <div class="modal-content">

      <!-- Modal Header -->
      <div class="modal-header">
        <h4 class="modal-title">AMAZON CHARGES</h4>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>

      <!-- Modal body -->
      <div class="modal-body">
        <p class="success-msg" style="color:green; display:none">Added succesfully,  refresh the page to see the changes.</p>

        <p class="showvalues" style="font-size: 12px;"></p>
        <form class="form" action="<?php echo e(route('receivables.save_unpresented')); ?>" method="POST" id="addpayable">
          <?php echo csrf_field(); ?>
          <input type="hidden" name="invTypechange" id="invTypechange" value="credit" />
          <input type="hidden" name="getewayTypechange" id="getewayTypechange" value="paypal" />

          <div class="form-body">
        
             
                          <select id="unprecented_bank" class="form-control"
                              name="unprecented_bank">
                             
                              <option value="41" data-type="paypal">Amazon Pay</option>
                         
                          </select>
                          
                          <br>
           
                          <input type="date" id="unprecented_date" style="100% !important"
                              class="form-control" name="unprecented_date" required>

                 
              
                          <br>
                
           
                   
                          <input type="text" id="unprecented_amount" class="form-control" style="100% !important"
                              placeholder="Amount" name="unprecented_amount" readonly value="<?php echo e($single_record['invoice_total'] ? $single_record['invoice_total'] : 0); ?>">

                              <input name="invids[]" type="hidden" value="<?php echo e($invoiceId); ?>">
                              <input name="totalamount[<?php echo e($invoiceId); ?>]" type="hidden" value="<?php echo e($single_record['invoice_total'] ? $single_record['invoice_total'] : 0); ?>">
                              <br>
                      
                          <input type="text" id="unprecented_cc" class="form-control" style="100% !important"
                              placeholder="Charges" name="unprecented_cc" value="0">

                 

                  <button type="submit"
                      class="btn btn-success waves-effect waves-light mt-2 " id="addpayablebtn">Add Payment</button>

              
          </div>
     
   
  </form>
      </div>

   

    </div>
  </div>
</div>
  <?php 

$invoicesingle_record = $single_record['invoice'];
?>
              
              <?php if(request()->get('onlysheet') == 4): ?>  <?php if($single_record['cc_amazon']): ?> <?php echo e($single_record['cc_amazon']); ?> <?php else: ?> <a href="javascript:void(0)" style="color:#fff" onclick="getSoNumber('<?php echo e($invoicesingle_record); ?>')" data-toggle="modal" data-target="#cc_amazonModal<?php echo e($invoiceId); ?>">+ charges</a> <?php endif; ?>   <?php else: ?><?php echo e($single_record['cc_amazon'] ? $single_record['cc_amazon'] : '-'); ?><?php endif; ?></td>
           
            <?php 

          $net_sale_amount = $single_record['net_sale_amount'] ? $single_record['net_sale_amount'] :  0;

          ?>
            <td class="tdlightgreen netamount"><?php echo e($net_sale_amount ? (double)$single_record['net_sale_amount'] : '-'); ?></td>
            <td ><?php echo e($single_record['po_number'] ? $single_record['po_number'] : '-'); ?></td>
            <td ><?php echo e($single_record['vendor'] ? $single_record['vendor'] : '-'); ?></td>
            <td ><?php echo e($single_record['invoice_no'] ? $single_record['invoice_no'] : '-'); ?></td>
            <td ><?php echo e($single_record['pinvoice_date'] ? $single_record['pinvoice_date'] : '-'); ?></td>
       <?php $invoice_amount = $single_record['invoice_amount'] ? $single_record['invoice_amount'] : 0; 
        $pototalamount[] = $invoice_amount;
       
       ?>
            <td class="tdblue pototalamount"><?php echo e($single_record['invoice_amount'] ? $single_record['invoice_amount'] : '-'); ?></td>
        
            <td ><?php echo e($single_record['payable_tracking'] ? $single_record['payable_tracking'] : '-'); ?></td>
              <?php $grossprofit[] = $net_sale_amount-$invoice_amount; ?>
            <td class="tdlightbrown"><?php echo e(number_format($net_sale_amount-$invoice_amount,2)); ?></td>
          </tr>
           <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>
 

        
        
    </div>
    <?php 
      $totalgrosssale = array_sum($grosssale);
      $totalsalefrieght = array_sum($salefrieght);
      $totalsaletax = array_sum($saletax);
      $totalcccharges = array_sum($cccharges);
      $totalpototalamount = array_sum($pototalamount);
      $grossprofit = array_sum($grossprofit);

      
    ?>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>

    
 <script src="<?php echo e(asset('app-assets/vendors/js/extensions/sweetalert2.all.min.js')); ?>"></script>
 <script src="<?php echo e(asset('app-assets/js/scripts/extensions/sweet-alerts.js')); ?>"></script>
    <script>
const departmentArray = { 
  "1": "Commercial", 
  "2": "GSA", 
  "3": "Bidding", 
  "4": "Amazon", 
  "5": "NA", 
  "6": "Open Market"
};
    

      $(document).ready(function(){
        $('#gross-sale').text('$<?php echo e(number_format($totalgrosssale, 2)); ?>')
        $('#sale-frieght').text('$<?php echo e(number_format($totalsalefrieght, 2)); ?>')
        $('#sale-tax').text('$<?php echo e(number_format($totalsaletax, 2)); ?>')
        $('#order-total').text('$<?php echo e(number_format($totalgrosssale+$totalsalefrieght+$totalsaletax, 2)); ?>')
        $('#cc-charges').text('$<?php echo e(number_format($totalcccharges, 2)); ?>')
        $('#net-amount').text('$<?php echo e(number_format($totalgrosssale+$totalsalefrieght+$totalsaletax+$totalcccharges, 2)); ?>')
      
        $('#po-total-amount').text('$<?php echo e(number_format($totalpototalamount, 2)); ?>')
        $('#gross-profit').text('$<?php echo e(number_format($grossprofit, 2)); ?>')
     
});

function updateDate(invid){

  var datev = $('#somonth-'+invid).val();
  if(!datev){
    alert('select date');
    return false;
  }

  $.ajax({
      type: "POST",
      url: "<?php echo e(route('salesorder-month-year-update')); ?>",
      data:{
        'salesorderMonthYear' : datev,
        _token: "<?php echo e(csrf_token()); ?>",
        'invid': invid

      },
      beforeSend: function() {
          
         

      },
      success: function(response) {
         
      
        if (response.type === "success") {
                        
                            Swal.fire({
                                type: "success",
                                title: 'Month Updated!',
                                text: response.msg,
                                confirmButtonClass: 'btn btn-success',
                            })
                        } else {
                            Swal.fire({
                                title: "Error!",
                                text: response.msg,
                                type: "error",
                                confirmButtonClass: 'btn btn-primary',
                                buttonsStyling: false,
                            });
                        }

      }
  });

}


function changeDept(invid){

  var selecteddept = $('#selected-dept-'+invid+' option:selected').val();
  var selecteddeptext = $('#selected-dept-'+invid+' option:selected').text();
  


$.ajax({
    type: "POST",
    url: "<?php echo e(route('invoice-department-update')); ?>",
    data:{
      'selecteddept' : selecteddept,
      _token: "<?php echo e(csrf_token()); ?>",
      'invoiceId': invid

    },
    beforeSend: function() {
        
       

    },
    success: function(response) {
       
    
      if (response.type === "success") {
                      
                          Swal.fire({
                              type: "success",
                              title: 'ORDER SOURCE Updated!',
                              text: response.msg,
                              confirmButtonClass: 'btn btn-success',
                          })
                          $('#show-dept-'+invid).text(selecteddeptext);
                          showHideDept(invid, 0)
                      } else {
                          Swal.fire({
                              title: "Error!",
                              text: response.msg,
                              type: "error",
                              confirmButtonClass: 'btn btn-primary',
                              buttonsStyling: false,
                          });
                      }

    }
});

}

function showHideDept(inv, status){

  if(status === 1){
    $('#hide-dept-'+inv).show();
    $('#selected-dept-'+inv).show();
    $('#show-dept-'+inv).hide();
  }else{
    $('#hide-dept-'+inv).hide();
    $('#selected-dept-'+inv).hide();
    $('#show-dept-'+inv).show();
  }
}

var ajaxCallCounter = 0;
var indexKey = 0;
const months = [
  "January", 
  "February", 
  "March", 
  "April", 
  "May", 
  "June", 
  "July", 
  "August", 
  "September", 
  "October", 
  "November", 
  "December"
];

const getAmountCalcuation = () => {
  $('#gross-sale').text('$0')
        $('#sale-frieght').text('$0')
        $('#sale-tax').text('$0')
        $('#order-total').text('$0')
        $('#cc-charges').text('$0')
        $('#net-amount').text('$0')
        $('#po-total-amount').text('$0')
        $('#gross-profit').text('$0')
        
}


requestYearlyReport = () =>{
  ajaxCallCounter = 0;
  getYearlyReport();
}
const getYearlyReport = () => {
 
  if (ajaxCallCounter < 1) {
  $('#myTable').empty()
  }

let currentMonth = ajaxCallCounter+1;
var selectedyear = $('#dealYear option:selected').val();

        $.ajax({
    type: "GET",
    url: "<?php echo e(route('profit-loss-month')); ?>?dealMonth="+currentMonth+"&dealYear="+selectedyear,
   
    beforeSend: function() {
    

       $('#month-progess').text(`Loading month ${months[ajaxCallCounter]} , please wait.....`)

    },
    success: function(response) {
      
   let tableHTML = "";
    
      response.forEach((invoice, index) => {
 
     
        console.log(invoice.month)
    tableHTML += `<tr>
            <td>${ ++indexKey }</td>
            <td >${ invoice.month }</td>
            <td >${ departmentArray[invoice.thetype] ? departmentArray[invoice.thetype] : '' } </td>
            <td >${ invoice.invoice }</td>
            <td >${ invoice.invoice_date}</td>
            <td >${ invoice.reference } </td>
            <td >${ invoice.customer } </td>
            <td class="tdstate">${ invoice.state } </td>
            <td class="tdlightblue grosssalesmount">${ invoice.gross_sale ? Number(invoice.gross_sale).toFixed(2) : '-' } </td>
            <td class="tdlightblue frieghtamount">${ invoice.frieght ? Number(invoice.frieght).toFixed(2) : '-' }</td>
            <td class="tdlightblue salestaxth">${ invoice.tax ? Number(invoice.tax).toFixed(2) : '-' }</td>
            <td class="tdlightgreen grosssale"> ${ invoice.invoice_total ? Number(invoice.invoice_total).toFixed(2) : '-' }</td>
            <td class="tdlightblue cccharges">${ invoice.cc_amazon ? Number(invoice.cc_amazon).toFixed(2) : '-' }</td>
            <td class="tdlightgreen netamount">${ invoice.net_sale_amount ? Number(invoice.net_sale_amount).toFixed(2) : '-' }</td>
            <td >${ invoice.po_number }</td>
            <td >${ invoice.vendor }</td>
            <td >${ invoice.invoice_no }</td>
            <td >${ invoice.pinvoice_date }</td>
            <td class="tdblue pototalamount">${ invoice.invoice_amount ? Number(invoice.invoice_amount).toFixed(2) : '-' }</td>
            <td >${ invoice.payable_tracking}</td>
            <td class="tdlightbrown grossprofit">${Number(invoice.net_sale_amount-invoice.invoice_amount).toFixed(2)}</td>
          </tr>`;
});



$('#myTable').append(tableHTML)
ajaxCallCounter++;

if (ajaxCallCounter < 12) {
  $('#month-progess').text('loading next month')
  getYearlyReport()
}else{
  

  setTimeout(function() {
    $('#month-progess').text('')
    }, 5000);

}
sumthevalues()
    },
    error: function(error) {
      console.log('Error occurred: ', error);
    }
});

}


const sumthevalues = () =>{

  var grosssale = 0;
$('.grosssalesmount').each(function() {

 


  var value = $(this).text();
  if (value.indexOf('-') !== -1) { // Check if the value contains "-"
    value = 0; // Set the value to 0 if it contains "-"
  } else {
    value = parseFloat(value); // Convert the value to an integer if it doesn't contain "-"
  }
  grosssale += value;


});
$('#gross-sale').text('$'+grosssale.toFixed(2))


var frieghtamount = 0;
$('.frieghtamount').each(function() {


  var value = $(this).text();
  if (value.indexOf('-') !== -1) { // Check if the value contains "-"
    value = 0; // Set the value to 0 if it contains "-"
  } else {
    value = parseFloat(value); // Convert the value to an integer if it doesn't contain "-"
  }
  frieghtamount += value;


});
$('#sale-frieght').text('$'+frieghtamount.toFixed(2))


var salestaxth = 0;
$('.salestaxth').each(function() {


  var value = $(this).text();
  if (value.indexOf('-') !== -1) { // Check if the value contains "-"
    value = 0; // Set the value to 0 if it contains "-"
  } else {
    value = parseFloat(value); // Convert the value to an integer if it doesn't contain "-"
  }
  salestaxth += value;


});
$('#sale-tax').text('$'+salestaxth.toFixed(2))



var salestaxth = 0;
$('.salestaxth').each(function() {


  var value = $(this).text();
  if (value.indexOf('-') !== -1) { // Check if the value contains "-"
    value = 0; // Set the value to 0 if it contains "-"
  } else {
    value = parseFloat(value); // Convert the value to an integer if it doesn't contain "-"
  }
  salestaxth += value;


});
$('#sale-tax').text('$'+salestaxth.toFixed(2))




var grosssale = 0;
$('.grosssale').each(function() {


  var value = $(this).text();
  if (value.indexOf('-') !== -1) { // Check if the value contains "-"
    value = 0; // Set the value to 0 if it contains "-"
  } else {
    value = parseFloat(value); // Convert the value to an integer if it doesn't contain "-"
  }
  grosssale += value;


});
$('#order-total').text('$'+grosssale.toFixed(2))


var cccharges = 0;
$('.cccharges').each(function() {


  var value = $(this).text();
  if (value.indexOf('-') !== -1) { // Check if the value contains "-"
    value = 0; // Set the value to 0 if it contains "-"
  } else {
    value = parseFloat(value); // Convert the value to an integer if it doesn't contain "-"
  }
  cccharges += value;


});
$('#cc-charges').text('$'+cccharges.toFixed(2))



var netamount = 0;
$('.netamount').each(function() {


  var value = $(this).text();
  if (value.indexOf('-') !== -1) { // Check if the value contains "-"
    value = 0; // Set the value to 0 if it contains "-"
  } else {
    value = parseFloat(value); // Convert the value to an integer if it doesn't contain "-"
  }
  netamount += value;


});
$('#net-amount').text('$'+netamount.toFixed(2))



var pototalamount = 0;
$('.pototalamount').each(function() {


  var value = $(this).text();
  if (value.indexOf('-') !== -1) { // Check if the value contains "-"
    value = 0; // Set the value to 0 if it contains "-"
  } else {
    value = parseFloat(value); // Convert the value to an integer if it doesn't contain "-"
  }
  pototalamount += value;


});
$('#po-total-amount').text('$'+pototalamount.toFixed(2))


var grossprofit = 0;
$('.grossprofit').each(function() {


  var value = $(this).text();
  if (value.indexOf('-') !== -1) { // Check if the value contains "-"
    value = 0; // Set the value to 0 if it contains "-"
  } else {
    value = parseFloat(value); // Convert the value to an integer if it doesn't contain "-"
  }
  grossprofit += value;


});
$('#gross-profit').text('$'+grossprofit.toFixed(2))

        

}

function displayTableRows(invoices){

//  let invoices = [{"invoiceId":2979,"thetype":3,"month":"Jan","invoice":"4833-1","invoice_date":"Jan,31 2022","reference":"NA","customer":"TATA Consultancy Services","state":"NJ","gross_sale":350,"frieght":0,"tax":0,"invoice_total":350,"cc_amazon":0,"net_sale_amount":350,"po_number":"4833A","vendor":"D&H Distributing -3092581000","invoice_no":"1023207196","pinvoice_date":"Jan,31 2022","payable_product_cost":328.38,"payable_frieght":16.97,"payable_tax":0,"payable_ecw":0,"invoice_amount":345.35,"payable_tracking":"550581393906","gross_profit":0}, 
//  {"invoiceId":2980,"thetype":3,"month":"Jan","invoice":"4833-2","invoice_date":"Jan,31 2022","reference":"NA","customer":"Microsoft Corporation","state":"CA","gross_sale":500,"frieght":0,"tax":0,"invoice_total":500,"cc_amazon":0,"net_sale_amount":500,"po_number":"4833B","vendor":"Ingram Micro Distribution LLC","invoice_no":"1017100159","pinvoice_date":"Jan,31 2022","payable_product_cost":464.8,"payable_frieght":15.52,"payable_tax":0,"payable_ecw":0,"invoice_amount":480.32,"payable_tracking":"1Z853V170313439760","gross_profit":0}];

// let tableHTML = "";




}

const showAllYearButton = () => {
  
  let dealMonth = $('#dealMonth').val()

  if(dealMonth === 'all'){
       $('#submit-form').hide()
        $('#button-form').show()
  }else{
    $('#submit-form').show()
        $('#button-form').hide()
  }

 

}




$(document).on('submit', '#addpayable', function (event) {
  event.preventDefault();

  var form = $(this);
  var url = form.attr('action');

  $.ajax({
    type: "POST",
    url: url,
    data: form.serialize(),
    beforeSend: function () {
      $('#addpayablebtn').hide();

    },
    success: function (response) {
      $('#addpayablebtn').show(200);
      $('.success-msg').show(); // Display the element
      $('#unprecented_cc').val(0)

  // Delay for 4 seconds and then hide the element
  $('.success-msg').delay(5000).fadeOut();
    },
    error: function (xhr, status, error) {
      // Code to handle the error response
    }
  });
});


function getSoNumber(sonumber){
  
  $.ajax({
  type: "GET",
  url: "/reports/invoice-dateetc?invoiceId="+sonumber,
  success: function(response) {
   
   
    $('.showvalues').empty()
    $('.showvalues').html(response);

  },
  error: function(xhr, status, error) {
    // Code to handle the error response
  }
});
}


    </script>
</body>
</html>
<?php /**PATH /home3/itdevic1/public_html/erpreporting/resources/views/reports/profit-loss/profit-loss-sheet.blade.php ENDPATH**/ ?>