    <div class="row">
        <div class="col">
            <?php
            $orderCompany = $order->company;
            $dealTaxValue = 0;
            $dealChargeAmount = 0;
            $dealShippingCharges = 0;
            $dealCreditCardCharges = 0;
            ?>
        <?php echo $__env->make('partials.company-info', ['info' => $orderCompany], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
        <div class="col">

            <div class="row">
                <?php
                     $orderType = 'Quote';
                     $dealStatus = $order->dealStatus;
                     $proceedTo = '';

                     if($dealStatus == 'pending'){
                        $orderType = 'Quote';
                     }else{
                        $orderType = 'Sale Order';
                     }

                     if($dealStatus == 'pending'){

                        $proceedTo = 'confirmed';
                        $proceedText = 'Proceed to Accounts';

                     }else if($dealStatus == 'confirmed'){

                        $proceedTo = 'purchase';
                        $proceedText = 'Proceed to Purchase';

                     }else if($dealStatus == 'purchase'){

                        $proceedTo = 'placed';
                        $proceedText = 'Proceed to Accounts';

                     }else if($dealStatus == 'placed'){

                        $proceedTo = 'closed';
                        $proceedText = 'Close Order';
                     }
                     else if($dealStatus == 'closed'){

                        $proceedTo = '';
                        $proceedText = '';
                        }

                     ?>
                     <?php if($dealStatus == "pending"): ?>
                <form action="<?php echo e(route('orders.proceed-order', bin2hex($order->dealName))); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="orderStatus" value="<?php echo e($proceedTo); ?>" />

                    <button type="submit" class="btn btn-success mr-1 mb-1 waves-effect waves-light"><i
                        class="feather icon-activity"></i> <?php echo e($proceedText); ?> </button>

                </form>
                <?php endif; ?>
                
            </div>
            <div class="row">
                <h2><?php echo e($orderType); ?></h2>
            </div>
            <div class="row">
                <div class="table-responsive">
                    <table class="table">
                        <tbody>
                            <tr>
                                <th class="invoice_top_right_tdth">Order</th>
                                <td class="invoice_top_right_tdth"><?php echo e($order->dealName); ?></td>
                            </tr>
                            <tr>
                                <th class="invoice_top_right_tdth">SO#</th>
                                <td class="invoice_top_right_tdth">
                                    <?php echo e($order->dealSO ? $order->company->companyPrefix . '' . $order->dealSO : '-'); ?>

                                </td>
                            </tr>
                            <tr>
                                <th class="invoice_top_right_tdth">Customer Ref#</th>
                                <td class="invoice_top_right_tdth"><?php echo e($order->dealRef); ?></td>
                            </tr>
                            <tr>
                                <th class="invoice_top_right_tdth">Order Date</th>
                                <td class="invoice_top_right_tdth">
                                    <?php echo e(date('M d, yy', strtotime($order->dealCreatedAt))); ?></td>
                            </tr>

                            <tr>
                                <th class="invoice_top_right_tdth">Payment Term</th>
                                <td class="invoice_top_right_tdth"><?php echo e($order->dealPaymentMethod); ?></td>
                            </tr>

                         
                        </tbody>
                    </table>
                </div>

            </div><!-- end -->
        </div>
    </div><!-- before billing shipping completed -->

    <div class="row">
        <div class="col">
            <!-- Invoice Items Details -->
            <div id="invoice-items-details" class="pt-1 invoice-items-table">
                <div class="row">
                    <div class="table-responsive col-sm-12 p20">
                        <table class="table table-borderless">
                            <thead>
                                <tr class="bgblue_heading ">
                                    <th colspan="3" class="invoice_heading">Billing Address</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <th width="70%" class="invoice_top_right_tdth">Company Name</th>
                                    <th width="30%" class="invoice_top_right_tdth">Primary Contact</th>

                                </tr>
                                <tr>
                                    <td width="70%" class="invoice_top_right_tdth"><?php echo e($order->dealCompanyName); ?>

                                    </td>
                                    <td width="30%" class="invoice_top_right_tdth"><?php echo e($order->dealPrimaryContact); ?>

                                    </td>
                                </tr>
                                <tr>
                                    <th width="100%" class="invoice_top_right_tdth">Address</th>
                                </tr>
                                <tr>
                                    <td width="100%" class="invoice_top_right_tdth"><?php echo e($order->dealAddress); ?>

                                </tr>
                                <tr>
                                    <th width="33%" class="invoice_top_right_tdth">City</th>
                                    <th width="33%" class="invoice_top_right_tdth">State</th>
                                    <th width="33%" class="invoice_top_right_tdth">Zip/Postal</th>
                                </tr>
                                <tr>
                                    <td width="33%" class="invoice_top_right_tdth"><?php echo e($order->dealCity); ?></td>
                                    <td width="33%" class="invoice_top_right_tdth"><?php echo e($order->dealState); ?></td>
                                    <td width="33%" class="invoice_top_right_tdth"><?php echo e($order->dealPostalCode); ?>

                                    </td>

                                </tr>
                                <tr>
                                    <th width="40%" class="invoice_top_right_tdth">Phone</th>
                                    <th width="60%" class="invoice_top_right_tdth">Email</th>
                                </tr>
                                <tr>
                                    <td width="33%" class="invoice_top_right_tdth"><?php echo e($order->dealPhone); ?></td>
                                    <td width="33%" class="invoice_top_right_tdth"><?php echo e($order->dealEmail); ?></td>

                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <div class="col">

            <!-- Invoice Items Details -->
            <div id="invoice-items-details" class="pt-1 invoice-items-table">
                <div class="row">
                    <div class="table-responsive col-sm-12">
                        <table class="table table-borderless">
                            <thead>
                                <tr class="bgblue_heading">
                                    <th colspan="3" class="invoice_heading">Shipping Address</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <th width="70%" class="invoice_top_right_tdth">Company Name</th>
                                    <th width="30%" class="invoice_top_right_tdth">Primary Contact</th>

                                </tr>
                                <tr>
                                    <td width="70%" class="invoice_top_right_tdth">
                                        <?php echo e($order->dealShippingCompany); ?></td>
                                    <td width="30%" class="invoice_top_right_tdth">
                                        <?php echo e($order->dealShippingContact); ?></td>
                                </tr>
                                <tr>
                                    <th width="100%" class="invoice_top_right_tdth">Address</th>
                                </tr>
                                <tr>
                                    <td width="100%" class="invoice_top_right_tdth">
                                        <?php echo e($order->dealShippingAddress); ?>

                                </tr>
                                <tr>
                                    <th width="33%" class="invoice_top_right_tdth">City</th>
                                    <th width="33%" class="invoice_top_right_tdth">State</th>
                                    <th width="33%" class="invoice_top_right_tdth">Zip/Postal</th>
                                </tr>
                                <tr>
                                    <td width="33%" class="invoice_top_right_tdth">
                                        <?php echo e($order->dealShippingCity); ?></td>
                                    <td width="33%" class="invoice_top_right_tdth">
                                        <?php echo e($order->dealShippingState); ?></td>
                                    <td width="33%" class="invoice_top_right_tdth">
                                        <?php echo e($order->dealShippingZip); ?></td>

                                </tr>
                                <tr>
                                    <th width="40%" class="invoice_top_right_tdth">Phone</th>
                                    <th width="60%" class="invoice_top_right_tdth">Email</th>
                                </tr>
                                <tr>
                                    <td width="33%" class="invoice_top_right_tdth">
                                        <?php echo e($order->dealShippingPhone); ?></td>
                                    <td width="33%" class="invoice_top_right_tdth">
                                        <?php echo e($order->dealShippingEmail); ?></td>

                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <div class="row">
        <div class="table-responsive col-sm-12">
            <table class="table table-borderless border4 ">
                <thead>
                    <tr class="bgblue_heading">
                        <th class="invoice_heading">Sale Rep Name</th>
                        <th class="invoice_heading">Sale Rep Phone </th>
                        <th class="invoice_heading">Ship Via </th>
                        <th class="invoice_heading">Sale Rep Email</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><?php echo e($order->created_users->firstName . ' ' . $order->created_users->lastName); ?></td>
                        <td><?php echo e($order->created_users->phone); ?></td>
                        <td>UPS Ground</td>
                        <td><?php echo e($order->created_users->email); ?></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

    <div class="row">
        <div class="table-responsive col-sm-12">
            <table class="table table-borderless border4 ">
                <thead>
                    <tr class="bgblue_heading">
                        <th class="invoice_heading" width="20%">PART NO. </th>
                        <th class="invoice_heading" width="40%">DESCRIPTION </th>
                        <th class="invoice_heading" width="15%">UNIT PRICE </th>
                        <th class="invoice_heading" width="10%">Qty</th>
                        <th class="invoice_heading" width="15%">Total</th>

                    </tr>
                </thead>
                <tbody>
                    <?php
                    $subtotal = 0;
                    ?>
                    <?php $__currentLoopData = $order->dealItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($item->dealItemName); ?></td>
                            <td><?php echo e($item->dealItemDescription); ?></td>
                            <td><?php echo e($orderCompany->companyCurrency); ?> <?php echo e($item->dealItemUnitCost); ?></td>
                            <td><?php echo e($item->dealItemQuantity); ?></td>
                            <td><?php echo e($orderCompany->companyCurrency); ?>  <?php echo e($item->dealItemUnitCost * $item->dealItemQuantity); ?></td>
                            <?php
                            $itemCost = $item->dealItemUnitCost * $item->dealItemQuantity;
                            $subtotal =  $subtotal + $itemCost;
                            ?>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>


    <div class="row justify-content-end">
        <div class="col col-md-7">
            <div class="row" style="display:none">
                <div class="col-12">
                    <table class="table table-borderless">
                        <tbody>
                            <tr class="borderbottom">
                                <th width="100%" class="invoice_top_right_tdth" colspan="3">ACH/Wire
                                    instructions </th>
                            </tr>
                            <tr>
                                <th width="25%" class="invoice_top_right_tdth">Account Title</th>
                                <td width="25%" class="invoice_top_right_tdth">IT DEVICES ONLINE INC</td>
                                <th width="25%" class="invoice_top_right_tdth">Account Number</th>
                                <td width="25%" class="invoice_top_right_tdth">80010516542</td>
                            </tr>
                            <tr>
                                <th width="25%" class="invoice_top_right_tdth">ABA / Routing Number</th>
                                <td width="25%" class="invoice_top_right_tdth">321081669</td>
                                <th width="25%" class="invoice_top_right_tdth">SWIFT Code</th>
                                <td width="25%" class="invoice_top_right_tdth">FRBBUS6S</td>
                            </tr>
                            <tr>
                                <th width="10%" class="invoice_top_right_tdth">Bank Name</th>
                                <td width="20%" class="invoice_top_right_tdth">First Republic Bank</td>
                                <th width="20%" class="invoice_top_right_tdth">Bank Address</th>
                                <td width="50%" class="invoice_top_right_tdth">111 Pine Street San Francisco, CA
                                    94111</td>

                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="row">
                <div class="col bordertop ">

                    <table class="table table-borderless">
                        <tbody>
                            <!-- <tr>
                                <th width="20%" class="tbhp">Payment Due</th>
                                <td width="80%" class="tbhp">07-23-22</td>
                            </tr> -->
                            <tr>
                                <th width="20%" class="tbhp">Tracking</th>
                                <td width="80%" class="tbhp">
                                    <?php $__empty_1 = true; $__currentLoopData = $purchases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $purchase): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <?php echo e($purchase->purchaseTracking); ?> <br>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    NA
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <th width="20%" class="tbhp">Serials</th>
                                <td width="80%" class="tbhp">
                                    <?php $__empty_1 = true; $__currentLoopData = $purchases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $purchase): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <?php echo e($purchase->purchaseSerial); ?> <br>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    NA
                                    <?php endif; ?>
                                </td>
                            </tr>
                        </tbody>
                    </table>

                </div>
            </div>
        </div>
        <div class="col-5">
            <div class="table-responsive mt25">
                <table class="table table-borderless ">
                    <tbody>
                        <?php if($order->dealCreditCardCharges > 0): ?>
                        <tr class="borderbottom">
                            <th>3.5% CC Charges (if any)</th>
                            <td><?php echo e($orderCompany->companyCurrency); ?>  <?php echo e($order->dealCreditCardCharges); ?></td>
                            <?php 
                            $dealCreditCardCharge = $order->dealCreditCardCharge;
                            ?>
                        </tr>
                        <?php endif; ?>
                        <tr class="borderbottom">
                            <th>SubTotal</th>
                            <td><?php echo e($orderCompany->companyCurrency); ?>  <?php echo e(number_format($subtotal, 2)); ?></td>
                        </tr>
                        <tr class="borderbottom">
                            <th>Shipping</th>
                            <td><?php echo e($orderCompany->companyCurrency); ?> <?php echo e($order->dealShippingCharges); ?></td>
                            <?php  $dealShippingCharges =  $order->dealShippingCharges;  ?>
                        </tr>
                        <tr class="borderbottom">
                            <th>Charges (<?php echo e($order->dealChargeType); ?>)</th>
                            <?php  $dealChargeAmount =  $order->dealChargeAmount; 
                                if($order->dealChargeType == 'Amazon Charges'){
                                    $dealChargeAmount = $dealChargeAmount *-1;
                                }
                                ?>
                            <td><?php echo e($orderCompany->companyCurrency); ?> <?php echo e($dealChargeAmount); ?></td>
                          
                        </tr>
                        <?php if($order->dealTaxValue > 0): ?>
                        <tr class="borderbottom">
                            <th>Tax(<?php echo e($order->dealTaxName); ?>)</th>

                            <td><?php echo e($orderCompany->companyCurrency); ?> <?php echo e($order->dealTaxValue); ?></td>
                            <?php  $dealTaxValue =  $order->dealTaxValue;  ?>
                        </tr>
                        <?php endif; ?>
                        <tr>
                            <th>TOTAL</th>
                            <td><?php echo e($orderCompany->companyCurrency); ?> <?php echo e(number_format($subtotal+$dealCreditCardCharges+$dealShippingCharges+$dealChargeAmount+$dealTaxValue, 2)); ?></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php /**PATH /home/mush/public_html/reporting/resources/views/orders/ajax/view.blade.php ENDPATH**/ ?>