<?php $__env->startSection('after-style'); ?>
<style>
    h5,
    .h5 {
        font-size: 0.9rem;
    }

    .card .card-title {
        font-weight: 600;
        font-size: 10pt;
    }
</style>


<?php $__env->stopSection(); ?>
<?php $__env->startSection('leftbar-orders-active', 'active'); ?>

<?php $__env->startSection('breadcrumbs'); ?>
<div class="content-header-left col-md-9 col-12 mb-2">
    <div class="row breadcrumbs-top">
        <div class="col-12">
            <h2 class="content-header-title float-left mb-0">Sales Orders</h2>
            <div class="breadcrumb-wrapper col-12">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="index.html">Home</a>
                    </li>
                    <li class="breadcrumb-item active">List
                    </li>
                </ol>
            </div>
        </div>
    </div>
</div>
<div class="content-header-right text-md-right col-md-3 col-12 d-md-block d-none">
    <div class="form-group breadcrum-right">
        <div class="dropdown">
            <button class="btn-icon btn btn-primary btn-round btn-sm dropdown-toggle" type="button"
                data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i
                    class="feather icon-settings"></i></button>
            <div class="dropdown-menu dropdown-menu-right"><a class="dropdown-item" href="#">Chat</a><a
                    class="dropdown-item" href="#">Email</a><a class="dropdown-item" href="#">Calendar</a>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('orders.partials.edit-order.new-item', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $dealShippingType = ["FedEx", "FedEx Ground", "FedEx Economy", "FedEx Priority", "DHL", "UPS", "USPS"];
$dealPaymentType = ["Credit Card","Paypal","Bank Transfer","Online-Paypal","Amazon"];


?>
<?php $__env->startSection('content-body'); ?>

<div style="display:none;">
    <div id="billing-local-state">
        <select class="form-control" id="dealState" name="dealState">

            <?php $__currentLoopData = $data['states']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($state->stateCode); ?>">
                <?php echo e($state->stateName); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>


    <div id="billing-intl-state">
        <input class="form-control" placeholder="State" type="text" name="dealState">
    </div>
</div>

<div style="display:none;">
    <div id="shipping-local-state">
        <select class="form-control" id="dealShippingState" name="dealShippingState">

            <?php $__currentLoopData = $data['states']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($state->stateCode); ?>">
                <?php echo e($state->stateName); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>


    <div id="shipping-intl-state">
        <input class="form-control" placeholder="State" type="text" required="" name="dealShippingState">
    </div>
</div>

<div class="content-body">
    <section>
        <div class="form form-horizontal">


            <div class="card">
                <div class="card-content">
                    <div class="card-body">

                        <div class="row justify-content-around">

                            <div class="col col-lg-4 mb10 mt25">
                                <?php echo $__env->make('partials.company-info', ['info' => $orderCompany], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <br>

                            </div>
                            <div class="col col-lg-4">
                                <div class="form form-horizontal">
                                    <div class="form-body">
                                        <div class="row">
                                            <div class="col-12">
                                                <div class="form-group row">
                                                    <div class="col-md-6">
                                                        <span>Order ID</span>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <?php echo e($order->dealName); ?>

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-12">
                                                <div class="form-group row">
                                                    <div class="col-md-6">
                                                        <span>Customer Ref #</span>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <input type="hidden" id="dealId" name="dealId"
                                                            value="<?php echo e($order->dealId); ?>">
                                                        <div id="dealRef-edit" class="hide">
                                                            <input type="text" id="dealRef" class="form-control"
                                                                name="dealRef" placeholder="Customer Ref #"
                                                                value="<?php echo e($order->dealRef); ?>" required>
                                                            <a href="javascript:void(0)"
                                                                onclick="dealRefAction('dealRef', 'save', <?php echo e($order->dealId); ?>)"><i
                                                                    class="feather icon-check"
                                                                    style="color: #6495ed;"></i></a>
                                                            <a href="javascript:void(0)"
                                                                onclick="dealRefAction('dealRef', 'cancel')"> <i
                                                                    class="feather icon-x"
                                                                    style="color: #d71a1c;"></i></a>
                                                        </div>
                                                        <div id="dealRef-non-edit">
                                                            <span id="dealRef-value"><?php echo e($order->dealRef); ?></span>
                                                            <a href="javascript:void(0)"
                                                                onclick="dealRefAction('dealRef', 'edit')"><i
                                                                    class="feather icon-edit-2"></i></a>
                                                        </div>

                                                    </div>

                                                </div>
                                            </div>
                                            <div class="col-12">
                                                <div class="form-group row">
                                                    <div class="col-md-4">
                                                        <span>Order Date</span>
                                                    </div>
                                                    <div class="col-md-8">
                                                        <div id="dealCreatedAt-edit" class="hide">
                                                            <input type="date" id="dealCreatedAt" class="form-control"
                                                                name="dealCreatedAt" placeholder="Customer Ref #"
                                                                value="<?php echo e(date('Y-m-d', strtotime($order->dealCreatedAt))); ?>"
                                                                required>
                                                            <a href="javascript:void(0)"
                                                                onclick="dealCreatedAtAction('dealCreatedAt', 'save', <?php echo e($order->dealId); ?>)"><i
                                                                    class="feather icon-check"
                                                                    style="color: #6495ed;"></i></a>
                                                            <a href="javascript:void(0)"
                                                                onclick="dealCreatedAtAction('dealCreatedAt', 'cancel')">
                                                                <i class="feather icon-x"
                                                                    style="color: #d71a1c;"></i></a>
                                                        </div>
                                                        <div id="dealCreatedAt-non-edit">
                                                            <span id="dealCreatedAt-value"><?php echo e(date('M d, Y',
                                                                strtotime($order->dealCreatedAt))); ?></span>
                                                            <a href="javascript:void(0)"
                                                                onclick="dealCreatedAtAction('dealCreatedAt', 'edit')"><i
                                                                    class="feather icon-edit-2"></i></a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-12">
                                                <?php echo $__env->make('orders.partials.edit-order.payment-type', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                            </div>
                                            <div class="col-12">

                                                <?php echo $__env->make('orders.partials.edit-order.sale-person', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
                <!--card-content-->
            </div>
            <!-- first card end -->
            <!-- shipping billing card start -->
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-content">
                            <div class="card-header">
                                <h4 class="card-title">Billing Address</h4>
                                <ul class="list-unstyled mb-0">
                                    <li class="d-inline-block mr-2">
                                        <fieldset>
                                            <div class="vs-radio-con">
                                                <input type="radio" name="billing_state_type" checked="" value="local">
                                                <span class="vs-radio">
                                                    <span class="vs-radio--border"></span>
                                                    <span class="vs-radio--circle"></span>
                                                </span>
                                                <span class="">Local</span>
                                            </div>
                                        </fieldset>
                                    </li>
                                    <li class="d-inline-block mr-2">
                                        <fieldset>
                                            <div class="vs-radio-con">
                                                <input type="radio" name="billing_state_type" value="international">
                                                <span class="vs-radio">
                                                    <span class="vs-radio--border"></span>
                                                    <span class="vs-radio--circle"></span>
                                                </span>
                                                <span class="">International</span>
                                            </div>
                                        </fieldset>
                                    </li>
                                </ul>
                            </div>
                            <div class="card-body">
                                <div class="form">
                                    <div class="form-body">
                                        <div class="row">
                                            <div class="col-md-6 col-12">
                                                <h5>Company Name</h5>
                                                <div id="dealCompanyName-edit" class="hide">
                                                    <input type="text" id="dealCompanyName" class="form-control"
                                                        name="dealCompanyName" placeholder="Customer Ref #"
                                                        value="<?php echo e($order->dealCompanyName); ?>" required>
                                                    <a href="javascript:void(0)"
                                                        onclick="dealCompanyNameAction('dealCompanyName', 'save', <?php echo e($order->dealId); ?>)"><i
                                                            class="feather icon-check" style="color: #6495ed;"></i></a>
                                                    <a href="javascript:void(0)"
                                                        onclick="dealCompanyNameAction('dealCompanyName', 'cancel')">
                                                        <i class="feather icon-x" style="color: #d71a1c;"></i></a>
                                                </div>
                                                <div id="dealCompanyName-non-edit">
                                                    <span id="dealCompanyName-value"><?php echo e($order->dealCompanyName); ?></span>
                                                    <a href="javascript:void(0)"
                                                        onclick="dealCompanyNameAction('dealCompanyName', 'edit')"><i
                                                            class="feather icon-edit-2"></i></a>
                                                </div>
                                            </div>
                                            <div class="col-md-6 col-12">
                                                <h5>Primary Contact</h5>
                                                <div id="dealPrimaryContact-edit" class="hide">
                                                    <input type="text" id="dealPrimaryContact" class="form-control"
                                                        name="dealPrimaryContact" placeholder="Customer Ref #"
                                                        value="<?php echo e($order->dealPrimaryContact); ?>" required>
                                                    <a href="javascript:void(0)"
                                                        onclick="dealPrimaryContactAction('dealPrimaryContact', 'save', <?php echo e($order->dealId); ?>)"><i
                                                            class="feather icon-check" style="color: #6495ed;"></i></a>
                                                    <a href="javascript:void(0)"
                                                        onclick="dealPrimaryContactAction('dealPrimaryContact', 'cancel')">
                                                        <i class="feather icon-x" style="color: #d71a1c;"></i></a>
                                                </div>
                                                <div id="dealPrimaryContact-non-edit">
                                                    <span id="dealPrimaryContact-value"><?php echo e($order->dealPrimaryContact); ?></span>
                                                    <a href="javascript:void(0)"
                                                        onclick="dealPrimaryContactAction('dealPrimaryContact', 'edit')"><i
                                                            class="feather icon-edit-2"></i></a>
                                                </div>
                                            </div>

                                            <div class="col-md-6 col-12">
                                                <h5>Address</h5>
                                                <div id="dealAddress-edit" class="hide">
                                                    <input type="text" id="dealAddress" class="form-control"
                                                        name="dealAddress" placeholder="Customer Ref #"
                                                        value="<?php echo e($order->dealAddress); ?>" required>
                                                    <a href="javascript:void(0)"
                                                        onclick="dealAddressAction('dealAddress', 'save', <?php echo e($order->dealId); ?>)"><i
                                                            class="feather icon-check" style="color: #6495ed;"></i></a>
                                                    <a href="javascript:void(0)"
                                                        onclick="dealAddressAction('dealAddress', 'cancel')"> <i
                                                            class="feather icon-x" style="color: #d71a1c;"></i></a>
                                                </div>
                                                <div id="dealAddress-non-edit">
                                                    <span id="dealAddress-value"><?php echo e($order->dealAddress); ?></span>
                                                    <a href="javascript:void(0)"
                                                        onclick="dealAddressAction('dealAddress', 'edit')"><i
                                                            class="feather icon-edit-2"></i></a>
                                                </div>
                                            </div>

                                            <div class="col-md-6 col-12">
                                                <h5>City</h5>
                                                <div id="dealCity-edit" class="hide">
                                                    <input type="text" id="dealCity" class="form-control"
                                                        name="dealCity" placeholder="Customer Ref #"
                                                        value="<?php echo e($order->dealCity); ?>" required>
                                                    <a href="javascript:void(0)"
                                                        onclick="dealCityAction('dealCity', 'save', <?php echo e($order->dealId); ?>)"><i
                                                            class="feather icon-check" style="color: #6495ed;"></i></a>
                                                    <a href="javascript:void(0)"
                                                        onclick="dealCityAction('dealCity', 'cancel')"> <i
                                                            class="feather icon-x" style="color: #d71a1c;"></i></a>
                                                </div>
                                                <div id="dealCity-non-edit">
                                                    <span id="dealCity-value"><?php echo e($order->dealCity); ?></span>
                                                    <a href="javascript:void(0)"
                                                        onclick="dealCityAction('dealCity', 'edit')"><i
                                                            class="feather icon-edit-2"></i></a>
                                                </div>
                                            </div>

                                            <div class="col-md-6 col-12">
                                                <h5>State</h5>
                                                <div id="dealState-edit" class="hide">
                                                    <div class="form-label-group">
                                                        <fieldset class="form-group mb-0" id="show-billing-state">

                                                        </fieldset>
                                                        <a href="javascript:void(0)"
                                                            onclick="dealStateAction('dealState', 'save', <?php echo e($order->dealId); ?>)"><i
                                                                class="feather icon-check"
                                                                style="color: #6495ed;"></i></a>
                                                        <a href="javascript:void(0)"
                                                            onclick="dealStateAction('dealState', 'cancel')"> <i
                                                                class="feather icon-x" style="color: #d71a1c;"></i></a>
                                                    </div>
                                                </div>
                                                <div id="dealState-non-edit">
                                                    <span id="dealState-value"><?php echo e($order->dealState); ?></span>
                                                    <a href="javascript:void(0)"
                                                        onclick="dealStateAction('dealState', 'edit')"><i
                                                            class="feather icon-edit-2"></i></a>
                                                </div>
                                            </div>
                                            <div class="col-md-6 col-12">
                                                <h5>Zip/Postal Code</h5>
                                                <div id="dealPostalCode-edit" class="hide">
                                                    <input type="text" id="dealPostalCode" class="form-control"
                                                        name="dealPostalCode" placeholder="Customer Ref #"
                                                        value="<?php echo e($order->dealPostalCode); ?>" required>
                                                    <a href="javascript:void(0)"
                                                        onclick="dealPostalCodeAction('dealPostalCode', 'save', <?php echo e($order->dealId); ?>)"><i
                                                            class="feather icon-check" style="color: #6495ed;"></i></a>
                                                    <a href="javascript:void(0)"
                                                        onclick="dealPostalCodeAction('dealPostalCode', 'cancel')"> <i
                                                            class="feather icon-x" style="color: #d71a1c;"></i></a>
                                                </div>
                                                <div id="dealPostalCode-non-edit">
                                                    <span id="dealPostalCode-value"><?php echo e($order->dealPostalCode); ?></span>
                                                    <a href="javascript:void(0)"
                                                        onclick="dealPostalCodeAction('dealPostalCode', 'edit')"><i
                                                            class="feather icon-edit-2"></i></a>
                                                </div>
                                            </div>

                                            <div class="col-md-6 col-12">
                                                <h5>Email</h5>
                                                <div id="dealEmail-edit" class="hide">
                                                    <input type="text" id="dealEmail" class="form-control"
                                                        name="dealEmail" placeholder="Customer Ref #"
                                                        value="<?php echo e($order->dealEmail); ?>" required>
                                                    <a href="javascript:void(0)"
                                                        onclick="dealEmailAction('dealEmail', 'save', <?php echo e($order->dealId); ?>)"><i
                                                            class="feather icon-check" style="color: #6495ed;"></i></a>
                                                    <a href="javascript:void(0)"
                                                        onclick="dealEmailAction('dealEmail', 'cancel')"> <i
                                                            class="feather icon-x" style="color: #d71a1c;"></i></a>
                                                </div>
                                                <div id="dealEmail-non-edit">
                                                    <span id="dealEmail-value"><?php echo e($order->dealEmail); ?></span>
                                                    <a href="javascript:void(0)"
                                                        onclick="dealEmailAction('dealEmail', 'edit')"><i
                                                            class="feather icon-edit-2"></i></a>
                                                </div>
                                            </div>


                                            <div class="col-md-6 col-12">
                                                <h5>Phone</h5>
                                                <div id="dealPhone-edit" class="hide">
                                                    <input type="text" id="dealPhone" class="form-control"
                                                        name="dealPhone" placeholder="Customer Ref #"
                                                        value="<?php echo e($order->dealPhone); ?>" required>
                                                    <a href="javascript:void(0)"
                                                        onclick="dealPhoneAction('dealPhone', 'save', <?php echo e($order->dealId); ?>)"><i
                                                            class="feather icon-check" style="color: #6495ed;"></i></a>
                                                    <a href="javascript:void(0)"
                                                        onclick="dealPhoneAction('dealPhone', 'cancel')"> <i
                                                            class="feather icon-x" style="color: #d71a1c;"></i></a>
                                                </div>
                                                <div id="dealPhone-non-edit">
                                                    <span id="dealPhone-value"><?php echo e($order->dealPhone); ?></span>
                                                    <a href="javascript:void(0)"
                                                        onclick="dealPhoneAction('dealPhone', 'edit')"><i
                                                            class="feather icon-edit-2"></i></a>
                                                </div>
                                            </div>


                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col">
                    <div class="card">
                        <div class="card-content">
                            <div class="card-header">
                                <h4 class="card-title">Shipping Address</h4>
                                <ul class="list-unstyled mb-0">
                                    <li class="d-inline-block mr-2">
                                        <fieldset>
                                            <div class="vs-radio-con">
                                                <input type="radio" name="state_type" checked="" value="local">
                                                <span class="vs-radio">
                                                    <span class="vs-radio--border"></span>
                                                    <span class="vs-radio--circle"></span>
                                                </span>
                                                <span class="">Local</span>
                                            </div>
                                        </fieldset>
                                    </li>
                                    <li class="d-inline-block mr-2">
                                        <fieldset>
                                            <div class="vs-radio-con">
                                                <input type="radio" name="state_type" value="international">
                                                <span class="vs-radio">
                                                    <span class="vs-radio--border"></span>
                                                    <span class="vs-radio--circle"></span>
                                                </span>
                                                <span class="">International</span>
                                            </div>
                                        </fieldset>
                                    </li>
                                </ul>
                            </div>
                            <div class="card-body mt10">
                                <div class="form">
                                    <div class="form-body">
                                        <div class="row">
                                            <div class="col-md-6 col-12">
                                                <h5>Company Name</h5>
                                                <div id="dealShippingCompany-edit" class="hide">
                                                    <input type="text" id="dealShippingCompany" class="form-control"
                                                        name="dealShippingCompany" placeholder="Company Name"
                                                        value="<?php echo e($order->dealShippingCompany); ?>" required>
                                                    <a href="javascript:void(0)"
                                                        onclick="dealShippingCompanyAction('dealShippingCompany', 'save', <?php echo e($order->dealId); ?>)"><i
                                                            class="feather icon-check" style="color: #6495ed;"></i></a>
                                                    <a href="javascript:void(0)"
                                                        onclick="dealShippingCompanyAction('dealShippingCompany', 'cancel')">
                                                        <i class="feather icon-x" style="color: #d71a1c;"></i></a>
                                                </div>
                                                <div id="dealShippingCompany-non-edit">
                                                    <span id="dealShippingCompany-value"><?php echo e($order->dealShippingCompany); ?></span>
                                                    <a href="javascript:void(0)"
                                                        onclick="dealShippingCompanyAction('dealShippingCompany', 'edit')"><i
                                                            class="feather icon-edit-2"></i></a>
                                                </div>
                                            </div>

                                            <div class="col-md-6 col-12">
                                                <h5>Primary Contact</h5>
                                                <div id="dealShippingContact-edit" class="hide">
                                                    <input type="text" id="dealShippingContact" class="form-control"
                                                        name="dealShippingContact" placeholder="Primary Contact"
                                                        value="<?php echo e($order->dealShippingContact); ?>" required>
                                                    <a href="javascript:void(0)"
                                                        onclick="dealShippingContactAction('dealShippingContact', 'save', <?php echo e($order->dealId); ?>, <?php echo e($order->dealId); ?>)"><i
                                                            class="feather icon-check" style="color: #6495ed;"></i></a>
                                                    <a href="javascript:void(0)"
                                                        onclick="dealShippingContactAction('dealShippingContact', 'cancel')">
                                                        <i class="feather icon-x" style="color: #d71a1c;"></i></a>
                                                </div>
                                                <div id="dealShippingContact-non-edit">
                                                    <span id="dealShippingContact-value"><?php echo e($order->dealShippingContact); ?></span>
                                                    <a href="javascript:void(0)"
                                                        onclick="dealShippingContactAction('dealShippingContact', 'edit')"><i
                                                            class="feather icon-edit-2"></i></a>
                                                </div>
                                            </div>

                                            <div class="col-md-6 col-12">
                                                <h5>Address</h5>
                                                <div id="dealShippingAddress-edit" class="hide">
                                                    <input type="text" id="dealShippingAddress" class="form-control"
                                                        name="dealShippingAddress" placeholder="Address"
                                                        value="<?php echo e($order->dealShippingAddress); ?>" required>
                                                    <a href="javascript:void(0)"
                                                        onclick="dealShippingAddressAction('dealShippingAddress', 'save', <?php echo e($order->dealId); ?>)"><i
                                                            class="feather icon-check" style="color: #6495ed;"></i></a>
                                                    <a href="javascript:void(0)"
                                                        onclick="dealShippingAddressAction('dealShippingAddress', 'cancel')">
                                                        <i class="feather icon-x" style="color: #d71a1c;"></i></a>
                                                </div>
                                                <div id="dealShippingAddress-non-edit">
                                                    <span id="dealShippingAddress-value"><?php echo e($order->dealShippingAddress); ?></span>
                                                    <a href="javascript:void(0)"
                                                        onclick="dealShippingAddressAction('dealShippingAddress', 'edit')"><i
                                                            class="feather icon-edit-2"></i></a>
                                                </div>
                                            </div>

                                            <div class="col-md-6 col-12">
                                                <h5>City</h5>
                                                <div id="dealShippingCity-edit" class="hide">
                                                    <input type="text" id="dealShippingCity" class="form-control"
                                                        name="dealShippingCity" placeholder="City"
                                                        value="<?php echo e($order->dealShippingCity); ?>" required>
                                                    <a href="javascript:void(0)"
                                                        onclick="dealShippingCityAction('dealShippingCity', 'save', <?php echo e($order->dealId); ?>)"><i
                                                            class="feather icon-check" style="color: #6495ed;"></i></a>
                                                    <a href="javascript:void(0)"
                                                        onclick="dealShippingCityAction('dealShippingCity', 'cancel')">
                                                        <i class="feather icon-x" style="color: #d71a1c;"></i></a>
                                                </div>
                                                <div id="dealShippingCity-non-edit">
                                                    <span id="dealShippingCity-value"><?php echo e($order->dealShippingCity); ?></span>
                                                    <a href="javascript:void(0)"
                                                        onclick="dealShippingCityAction('dealShippingCity', 'edit')"><i
                                                            class="feather icon-edit-2"></i></a>
                                                </div>
                                            </div>


                                            <div class="col-md-6 col-12">
                                                <h5>State</h5>
                                                <div id="dealShippingState-edit" class="hide">
                                                    <div class="form-label-group">
                                                        <fieldset class="form-group mb-0" id="show-shipping-state">

                                                        </fieldset>

                                                        <a href="javascript:void(0)"
                                                            onclick="dealShippingStateAction('dealShippingState', 'save', <?php echo e($order->dealId); ?>)"><i
                                                                class="feather icon-check"
                                                                style="color: #6495ed;"></i></a>
                                                        <a href="javascript:void(0)"
                                                            onclick="dealShippingStateAction('dealShippingState', 'cancel')">
                                                            <i class="feather icon-x" style="color: #d71a1c;"></i></a>
                                                    </div>
                                                </div>
                                                <div id="dealState-non-edit">
                                                    <span id="dealShippingState-value"><?php echo e($order->dealShippingState); ?></span>
                                                    <a href="javascript:void(0)"
                                                        onclick="dealShippingStateAction('dealShippingState', 'edit')"><i
                                                            class="feather icon-edit-2"></i></a>
                                                </div>
                                            </div>

                                            <div class="col-md-6 col-12">
                                                <h5>Zip/Postal</h5>
                                                <div id="dealShippingZip-edit" class="hide">
                                                    <input type="text" id="dealShippingZip" class="form-control"
                                                        name="dealShippingZip" placeholder="Zip/Postal"
                                                        value="<?php echo e($order->dealShippingZip); ?>" required>
                                                    <a href="javascript:void(0)"
                                                        onclick="dealShippingZipAction('dealShippingZip', 'save', <?php echo e($order->dealId); ?>)"><i
                                                            class="feather icon-check" style="color: #6495ed;"></i></a>
                                                    <a href="javascript:void(0)"
                                                        onclick="dealShippingZipAction('dealShippingZip', 'cancel')">
                                                        <i class="feather icon-x" style="color: #d71a1c;"></i></a>
                                                </div>
                                                <div id="dealShippingZip-non-edit">
                                                    <span id="dealShippingZip-value"><?php echo e($order->dealShippingZip); ?></span>
                                                    <a href="javascript:void(0)"
                                                        onclick="dealShippingZipAction('dealShippingZip', 'edit')"><i
                                                            class="feather icon-edit-2"></i></a>
                                                </div>
                                            </div>


                                            <div class="col-md-6 col-12">
                                                <h5>Email</h5>
                                                <div id="dealShippingEmail-edit" class="hide">
                                                    <input type="text" id="dealShippingEmail" class="form-control"
                                                        name="dealShippingEmail" placeholder="Email"
                                                        value="<?php echo e($order->dealShippingEmail); ?>" required>
                                                    <a href="javascript:void(0)"
                                                        onclick="dealShippingEmailAction('dealShippingEmail', 'save', <?php echo e($order->dealId); ?>, <?php echo e($order->dealId); ?>)"><i
                                                            class="feather icon-check" style="color: #6495ed;"></i></a>
                                                    <a href="javascript:void(0)"
                                                        onclick="dealShippingEmailAction('dealShippingEmail', 'cancel')">
                                                        <i class="feather icon-x" style="color: #d71a1c;"></i></a>
                                                </div>
                                                <div id="dealShippingEmail-non-edit">
                                                    <span id="dealShippingEmail-value"><?php echo e($order->dealShippingEmail); ?></span>
                                                    <a href="javascript:void(0)"
                                                        onclick="dealShippingEmailAction('dealShippingEmail', 'edit')"><i
                                                            class="feather icon-edit-2"></i></a>
                                                </div>
                                            </div>

                                            <div class="col-md-6 col-12">
                                                <h5>Phone</h5>
                                                <div id="dealShippingPhone-edit" class="hide">
                                                    <input type="text" id="dealShippingPhone" class="form-control"
                                                        name="dealShippingPhone" placeholder="Phone"
                                                        value="<?php echo e($order->dealShippingPhone); ?>" required>
                                                    <a href="javascript:void(0)"
                                                        onclick="dealShippingPhoneAction('dealShippingPhone', 'save', <?php echo e($order->dealId); ?>)"><i
                                                            class="feather icon-check" style="color: #6495ed;"></i></a>
                                                    <a href="javascript:void(0)"
                                                        onclick="dealShippingPhoneAction('dealShippingPhone', 'cancel')">
                                                        <i class="feather icon-x" style="color: #d71a1c;"></i></a>
                                                </div>
                                                <div id="dealShippingPhone-non-edit">
                                                    <span id="dealShippingPhone-value"><?php echo e($order->dealShippingPhone); ?></span>
                                                    <a href="javascript:void(0)"
                                                        onclick="dealShippingPhoneAction('dealShippingPhone', 'edit')"><i
                                                            class="feather icon-edit-2"></i></a>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- shipping billing card end -->

            <!-- product repeater card start -->
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Line Items</h4>
                    <button type="button" class="btn float-right btn-outline-success btn-sm waves-effect waves-light"
                        data-toggle="modal" data-target="#inlineForm">
                        <i class="feather icon-plus"></i> Add
                    </button>


                </div>
                <div class="card-content">
                    <div class="card-body">

                        <div id="show-items"></div>

                    </div>

                </div>
            </div>
            <!-- product repeater card end -->




            <!-- other details card start -->
            <div class="row justify-content-center">
                <div class="col-5">
                    <div class="card">
                        <div class="card-content">
                            <div class="card-body">
                                <h4 class="card-title">Shipping Account</h4>
                                <form action="<?php echo e(route('update-shipping-info',  bin2hex($order->dealName))); ?>"
                                    method="POST">
                                    <?php echo csrf_field(); ?>
                                    <div class="row mt25">
                                        <div class="col-md-6 col-12">
                                            <div class="form-label-group">
                                                <fieldset class="form-group mb-0">
                                                    <select class="form-control" id="shippingAccount"
                                                        name="shippingAccount">
                                                        <option value="Drop Ship">Drop Ship</option>
                                                        <?php $__currentLoopData = $data['shipping_accounts']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shipping_account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($shipping_account->name); ?>"
                                                            <?php if($shipping_account->value == $order->dealShippingAccount): ?>
                                                            selected="" <?php endif; ?>>
                                                            <?php echo e($shipping_account->name); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                    </select>
                                                </fieldset>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <fieldset class="form-group">
                                                <input type="text" class="form-control" id="dealShippingAccount"
                                                    name="dealShippingAccount"
                                                    value="<?php echo e($order->dealShippingAccount); ?>">
                                            </fieldset>
                                        </div>
                                    </div>
                                    <div class="row mt25">
                                        <div class="col-12">

                                            <fieldset class="form-group">
                                                <textarea class="form-control" id="dealShippingComment"
                                                    name="dealShippingComment" rows="3"
                                                    placeholder="Comment"><?php echo e($order->dealShippingComment); ?></textarea>

                                            </fieldset>
                                        </div>
                                    </div>
                                    <button type="submit" class="btn btn-success btn-sm">update</button>
                                </form>

                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-5">
                    <div class="card">
                        <div class="card-content">
                            <div class="card-body">
                                <div class="row mt25">

                                    <div class="col-md-8 ">
                                        <p class="text-bold-600">
                                            SubTotal
                                        </p>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-label-group">
                                            $<span id="subTotal">000</span>
                                        </div>
                                    </div>

                                </div>
                                <?php if($order->dealCreditCardCharges > 0): ?>
                                <div class="row">
                                    <div class="col-md-7 ">
                                        <p class="text-bold-600">
                                            3.5% CC Charges (if any)
                                        </p>
                                    </div>

                                    <div class="col-md-5">
                                        <fieldset class="">
                                            <input type="text" class="form-control" name="dealCreditCardCharges"
                                                id="dealCreditCardCharges" placeholder="Credit Card Charges">
                                        </fieldset>
                                    </div>

                                </div>
                                <?php endif; ?>
                                <form action="<?php echo e(route('update-shipping-method',  bin2hex($order->dealName))); ?>"
                                    method="POST">
                                    <?php echo csrf_field(); ?>
                                    <div class="row">
                                        <div class="col-12 ">
                                            <p class="card-title ">
                                                Shipping Method</p>
                                        </div>

                                        <div class="col-7 mt8">
                                            <p class="text-bold-600">
                                                <select class="form-control required"
                                                    style="border-top: none;border-left: none;border-right: none;"
                                                    id="dealShippingType" name="dealShippingType">
                                                    <?php $__currentLoopData = $dealShippingType; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tyype): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($tyype); ?>" <?php if($tyype==$order->dealShippingType): ?>
                                                        selected="" <?php endif; ?>><?php echo e($tyype); ?> </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                                </select>

                                            </p>
                                        </div>
                                        <div class="col-5 mt8">
                                            <fieldset class="">
                                                <input type="number" class="form-control" onkeyup="forItemTotal()"
                                                    onkeydown="forItemTotal()" id="dealShippingCharges" min="0"
                                                    name="dealShippingCharges" step=".01"
                                                    value="<?php echo e($order->dealShippingCharges); ?>" required=""
                                                    oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');">

                                            </fieldset>
                                        </div>

                                        <div class="col-12 d-none">
                                            <div class="form-group">
                                                <a href="javascript:void(0)" data-toggle="modal"
                                                    data-target="#inlineFormm">Calculate Fedex Shipping</a>


                                                <div class="modal fade text-left" id="inlineFormm" tabindex="-1"
                                                    role="dialog" aria-labelledby="myModalLabel33"
                                                    style="display: none;" aria-hidden="true">
                                                    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable"
                                                        role="document">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h4 class="modal-title" id="myModalLabel33">Fedex
                                                                    Shipping
                                                                    Calculations</h4>
                                                                <button type="button" class="close" data-dismiss="modal"
                                                                    aria-label="Close">
                                                                    <span aria-hidden="true">×</span>
                                                                </button>
                                                            </div>
                                                            <div>
                                                                <div class="modal-body">
                                                                    <div class="form-group">
                                                                        <input type="text"
                                                                            placeholder="Enter Weight In Lbs"
                                                                            class="form-control">
                                                                    </div>
                                                                    <ul class="list-group">
                                                                        <li
                                                                            class="list-group-item d-flex justify-content-between align-items-center">
                                                                            <span> FedEx First Overnight</span>
                                                                            <span
                                                                                class="badge badge-primary badge-pill">4</span>
                                                                        </li>
                                                                        <li
                                                                            class="list-group-item d-flex justify-content-between align-items-center">
                                                                            <span> FedEx Standard Overnight</span>
                                                                            <span
                                                                                class="badge badge-primary badge-pill">2</span>
                                                                        </li>
                                                                        <li
                                                                            class="list-group-item d-flex justify-content-between align-items-center">
                                                                            <span> FedEx 2Days </span>
                                                                            <span
                                                                                class="badge badge-primary badge-pill">1</span>
                                                                        </li>
                                                                    </ul>
                                                                </div>
                                                                <div class="modal-footer">
                                                                    <button type="button"
                                                                        class="btn btn-primary waves-effect waves-light"
                                                                        data-dismiss="modal">Close</button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <button type="submit" class="btn btn-success btn-sm float-right">update</button>
                                    </div>


                                </form>
                                <form action="<?php echo e(route('update-charges-method',  bin2hex($order->dealName))); ?>"
                                    method="POST">
                                    <?php echo csrf_field(); ?>
                                    <div class="row">
                                        <div class="col-12 ">
                                            <p class="card-title ">Charges</p>
                                        </div>

                                        <div class="col-7 mt8">
                                            <p class="text-bold-600">
                                                <select class="form-control required"
                                                    style="border-top: none;border-left: none;border-right: none;"
                                                    id="dealChargeType" name="dealChargeType">
                                                    <option value="None">None </option>
                                                    <option value="Charges">Charges</option>
                                                    <option value="Amazon">Amazon</option>

                                                </select>
                                            </p>
                                        </div>

                                        <div class="col-5 mt8">
                                            <fieldset class="">
                                                <input type="number" onkeyup="forItemTotal()" onkeydown="forItemTotal()"
                                                    class="form-control" id="dealChargeAmount" min="0"
                                                    name="dealChargeAmount" step=".01"
                                                    value="<?php echo e($order->dealChargeAmount); ?>" required=""
                                                    oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');">

                                            </fieldset>
                                        </div>

                                        <button type="submit" class="btn btn-success btn-sm float-right">update</button>

                                    </div>

                                </form>
                                <div class="row ">
                                    <div class="col-md-8 ">
                                        <p class="text-bold-600">
                                            Total
                                        </p>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-label-group">
                                            $<span id="totalPrice">000</span>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>


        </div>


    </section>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('after-scripts'); ?>
<?php echo $__env->make('orders.scripts.modify', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script>


    $(document).ready(function () {
        show_billing_states()
        show_shipping_states()

        load_items()
    });




    function show_billing_states() {

        $('#show-billing-state').empty();

        var billing_state_type = $("input[name='billing_state_type']:checked").val();

        if (billing_state_type === 'local') {

            $("#billing-local-state").children().clone().appendTo("#show-billing-state");

            $('#show-billing-state select').removeAttr('id');
            $('#show-billing-state select').attr('id', 'billing-id-state');

            $('#dealCountry').val('<?php echo e($orderCompany->country->countryName); ?>');
        } else {
            $('#dealCountry').val('');
            $("#billing-intl-state").children().clone().appendTo("#show-billing-state");

        }




    }


    $('input[type=radio][name=state_type]').change(function () {
        show_shipping_states()
    });


    $('input[type=radio][name=billing_state_type]').change(function () {
        show_billing_states()
    });

    function show_shipping_states() {

        $('#show-shipping-state').empty();

        var shipping_state_type = $("input[name='state_type']:checked").val();
        console.log(shipping_state_type)
        if (shipping_state_type === 'local') {

            $("#shipping-local-state").children().clone().appendTo("#show-shipping-state");
            $('#show-shipping-state select').removeAttr('id');
            $('#show-shipping-state select').attr('id', 'shipping-id-state');
            $('#dealShippingCountry').val('<?php echo e($orderCompany->country->countryName); ?>');
        } else {

            $("#shipping-intl-state").children().clone().appendTo("#show-shipping-state");
            $('#dealShippingCountry').val('');
        }





    }


    function load_items() {





        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        $.ajax({
            type: "GET",
            url: "<?php echo e(route('orders.deal-items',  bin2hex($order->dealName))); ?>",
            beforeSend: function () {
                $('#show-items').empty();
                $('#show-items').html('<p>Loading....</p>');
            },
            success: function (data) {
                $('#show-items').empty();
                $('#show-items').html(data);

                forItemTotal()

            }
        });




    }

    function add_more_btn(sid) {
        if (sid > 0) {
            $('#showNew').show();
            $('#show-new-btn').hide();
        } else {
            $('#show-new-btn').show();
            $('#showNew').hide();
        }
    }

    function brandFunction(e) {
        pid = $(e).attr("brandid");
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        if (e.value !== '') {
            $.ajax({
                type: "POST",
                url: "<?php echo e(route('order-brands')); ?>",
                data: 'keyword=' + e.value,
                beforeSend: function () {
                    //  $(".dealItemName").css("background","#FFF");
                },
                success: function (data) {


                    $(e).next(".suggesstion-brand").show();

                    //     $('.suggesstion-brand').closest('.Level3').show();


                    var as = JSON.parse(data);

                    if (as.length > 0) {


                        var str = '';
                        for (var i = 0; i < as.length; i++) {

                            var name = as[i]["brandName"];
                            var id = as[i]["brandId"];


                            var valueString = '"' + pid + '~' + name + '"';

                            str += '<li onclick="selectBrand(' + i + ', ' + pid + ')" id="select-brand-' + i + '" style="cursor: pointer;">' + as[i]["brandName"] + '</li>';


                        }

                        //                       var name= 'dealItems['+j+'][dealItemName]';
                        $(".suggesstion-brand").empty();

                        $(e).next(".suggesstion-brand").append(str);


                    }

                    // $(".dealItemName").css("background","#FFF");
                }
            });
        }
        else {
            $(e).next(".suggesstion-brand").hide();
        }
    }

    function selectBrand(i, pid) {
        var pidtext = $('#select-brand-' + i).text();
        $('#dealItemBrand-' + pid).val(pidtext);
        $(".suggesstion-brand").empty();
        $(".suggesstion-brand").hide();

    }



    // this is the id of the form
    $("#idForm").submit(function (e) {

        e.preventDefault(); // avoid to execute the actual submit of the form.

        var form = $(this);
        var actionUrl = form.attr('action');

        $.ajax({
            type: "POST",
            url: actionUrl,
            data: form.serialize(), // serializes the form's elements.
            success: function (data) {

            }
        });

    });


    function partFunction(e, pid) {

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        if (e.value !== '') {
            $.ajax({
                type: "POST",
                url: "<?php echo e(route('order-parts')); ?>",
                data: 'keyword=' + e.value,
                beforeSend: function () {
                    //  $(".dealItemName").css("background","#FFF");
                },
                success: function (data) {


                    $(e).next(".suggesstion-part").show();

                    //     $('.suggesstion-brand').closest('.Level3').show();


                    var as = JSON.parse(data);

                    if (as.length > 0) {


                        var str = '';
                        for (var i = 0; i < as.length; i++) {


                            var diti = as[i]["dealItemId"];
                            var asid = as[i]["dealItemName"];
                            var description = as[i]["dealItemDescription"];
                            var unitPrice = as[i]["dealItemUnitCost"];
                            description = description.replace(/\s+/g, '``');

                            var valueString = pid + '~' + asid + '~' + unitPrice + '~' + description + '~' + diti;

                            str += '<li onclick="selectPart(' + i + ')" id="get-part-' + i + '" partno = "' + valueString + '"><a href="javascript:void(0)">' + as[i]["dealItemName"] + '</a></li>';


                        }

                        $(".suggesstion-part").empty();

                        $(e).next(".suggesstion-part").append(str);


                    }


                }
            });
        }
        else {
            $(e).next(".suggesstion-part").hide();
        }
    }


    function selectPart(iid) {

        var val = $('#get-part-' + iid).attr("partno");

        var arr = val.split('~');

        var dealItemDescription = arr[3].split('``').join(' ');

        $('#dealItemName-' + arr[0]).val(arr[1]);
        $('#dealItemUnitCost-' + arr[0]).val(arr[2]);
        $('#dealItemDescription-' + arr[0]).val(dealItemDescription);
        $('#dealItemQuantity-' + arr[0]).val(1);
        $('#dealItemTotal-' + arr[0]).val(arr[2] * 1);
        $('#dealItemId-' + arr[0]).val(arr[4]);





        $(".suggesstion-part").empty();
        $(".suggesstion-part").hide();

    }

    $("body").click
        (
            function (e) {
                if (e.target.className !== "special-hide") {
                    $(".suggesstion-part").hide();
                }
            }
        );

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mush/public_html/reporting/resources/views/orders/edit.blade.php ENDPATH**/ ?>