<?php $__env->startSection('leftbar-orders-active', 'active'); ?>

<?php $__env->startSection('breadcrumbs'); ?>
    <div class="content-header-left col-md-9 col-12 mb-2">
        <div class="row breadcrumbs-top">
            <div class="col-12">
                <h2 class="content-header-title float-left mb-0">Expenses</h2>
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html">Home</a>
                        </li>
                        <li class="breadcrumb-item active">List
                        </li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
  
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content-body'); ?>


<div class="content-body">
    <section id="sale-order-datatable">
        <div class="card m0">
            <div class="card-content">
                <div class="card-body">
                    <div class="row ">
                        <div class="col-12">    
                                    <?php
                                        if( $filterType == 'Head of Accounts'){
                                            $ttype = 'hoa';
                                        }else{
                                            $ttype = 'vendor';
                                        }
                                    ?>
                                <a href="<?php echo e(route('hoav.create', $ttype)); ?>" target="_blank" class="btn btn-primary btn-sm float-right">
                                   New <?php echo e($filterType); ?>

                                </a>
                         
                        </div>
                      </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Expense by <?php echo e($filterType); ?></h4>
                    </div>
                    <div class="card-content">
                        <div class="card-body card-dashboard">
                            <div class="table-responsive">
                                <table class="table zero-configuration">
                                    <thead>
                                        <tr>
                                            <th></th>
                                            <th style="    font-size: 22px;
                                            text-align: justify;
                                            color: brown;"><?php echo e(auth()->user()->company->companyCurrency); ?><?php echo e(number_format($overalltotal->total+$overalltotal->expenseTax,2)); ?></th>
                                          
                                        </tr>
                                        <tr>
                                            <th>Name</th>
                                            <th>Amount</th>
                                          
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $hoavs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expense): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($expense->hoavName); ?></td>
                                                <td><?php echo e(auth()->user()->company->companyCurrency); ?><?php echo e($expense->total+$expense->expenseTax); ?> </td>
                                               
                                                  
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <th>Name</th>
                                            <th>Amount</th>
                                     
                                        </tr>
                                    </tfoot>
                                </table>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('after-scripts'); ?>
    <script>
        $('#sale-order-datatable').DataTable();

function getExpensiveDetails(id){



$.ajaxSetup({
headers: {
  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
}

});

$.ajax({
type: "GET",
url: "/reporting/expense/"+id,

beforeSend: function() {
  
  $("#detail-invoice-"+id).empty();
  $("#detail-invoice-"+id).text('loading...');

},
success: function(data) {
 
$("#detail-invoice-"+id).empty();
$("#detail-invoice-"+id).html(data);


}
});
}

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home3/itdevic1/public_html/erpreporting/resources/views/reporting/expenses/filter.blade.php ENDPATH**/ ?>