<?php $__env->startSection('after-style'); ?>
<style>   
.td-font{
    font-size: 12px;
   }

   </style>

    <?php $__env->stopSection(); ?>

<?php $__env->startSection('leftbar-orders-active', 'active'); ?>

<?php $__env->startSection('breadcrumbs'); ?>
    <div class="content-header-left col-md-9 col-12 mb-2">
        <div class="row breadcrumbs-top">
            <div class="col-12">
                <h2 class="content-header-title float-left mb-0">Bank Transactions</h2>
               

            </div>
        </div>
    </div>
 
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content-body'); ?>
<?php

$categoryArray = ["INCOME", "PURCHASE", "EXPENSE"];

?>
<div class="content-body">
    <div class="modal fade mt-3" id="detailbank" tabindex="-1" role="dialog" aria-labelledby="myModalLabel1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-scrollable modal-lg" role="document">
            <div class="modal-content">
              
                <div class="modal-header">
                    <h4 class="modal-title" id="myModalLabel1"></h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="table-responsive">
                        <table class="table zero-configuration">
    
                            <thead id="table-head">
                               
                            </thead>
                            <tbody id="detail-invoices">
    
    
                        </table>
                        <div id="code-input" class="text-center">
                           
                          </div>
                    </div>
                </div>

                <div class="modal-footer" id="modal-footer-detail">
                </div>
                
            </div>
        </div>
    </div>
    <section id="sale-order-datatable">
        <div class="modal fade text-left" id="datefilters" tabindex="-1" role="dialog" aria-labelledby="myModalLabel1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-scrollable" role="document">
                <div class="modal-content">
                    <form action="<?php echo e(route('pdf.bank')); ?>" method="GET">
                    <div class="modal-header">
                        <h4 class="modal-title" id="myModalLabel1">Filter Transactions</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <input type="hidden" name="selected_bank" value="<?php echo e(request()->get('selected_bank')); ?>" />
                            <div class="col-md-4">
                                <select name="select_type" class="form-control" >
                                    <option value="all">ALL</option>
                                    <option value="INCOME">INCOME</option>
                                    <option value="PURCHASE">PURCHASE</option>
                                    <option value="EXPENSE">EXPENSE</option>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <input type="date" name="from_date" class="form-control" />
                            </div>
                            <div class="col-md-4">
                                <input type="date" name="to_date" class="form-control" />
                            </div>
                            <div class="col-md-4">
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary" >Filter</button>
                    </div>
                 </form>
                </div>
            </div>
        </div>
        
        <div class="row">
            <div class="col-12">
                
                <div class="card">
                    <div class="card-content">
                        <div class="card-body card-dashboard" style="padding-bottom: 0rem;">
                    <form method="GET" action=""> 
                        <div class="row ">
                         
                         <div class="col-6 ">
                            <input type="hidden" name="selected_bank" value="<?php echo e(request()->get('selected_bank')); ?>" />

                        </div>
                       
                      
                      
                            <div class="col-2">
                                <fieldset class="form-group">
                                    <select class="form-control" name="bankMonth" id="bankMonth">
                                        <!-- <option value="all" selected="">All</option> -->
                                <option value="all" <?php if($bankMonth == 'all'): ?> selected=""  <?php endif; ?> >All</option>

                                        <?php $__currentLoopData = $bankMonthArray; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $dm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                      

                                    <option value="<?php echo e($key); ?>" <?php if($bankMonth == $key): ?> selected=""  <?php endif; ?> ><?php echo e($dm); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </fieldset>
                                </div>
                                <div class="col-2">
                                <fieldset class="form-group">
                                    <select class="form-control" name="bankYear" id="bankYear">
                                    <?php $__currentLoopData = $bankYearArray; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $dy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($key); ?>" <?php if(request()->get("bankYear") == $key): ?> selected="" <?php elseif($key == date("y")): ?> selected="" <?php endif; ?> ><?php echo e($dy); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </fieldset>
                            </div>
                            <div class="col-2">
                                <button type="submit" class="btn btn-primary waves-effect waves-light">Show</button>
                            </div>
                        </div>
                        </form>
                        </div>
                    </div>
                </div>
                <div class="col-12">

                    <div class="card m0">
                        <div class="card-content">
                            <div class="card-body">
                                <?php echo $__env->make('banks.partials.summary', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Bank ~ <span><?php echo e($bank->bankAccountTitle); ?></span></h4>
                        
                       
                    </div>
                    <div class="card-content">
                        <div class="card-body card-dashboard">
                            <div class="table-responsive">
                                <table class="table zero-configuration">
                                    <thead>
                                        <tr>
                                            <th>Date</th>
                                            <th>Description</th>
                                            <th>Category</th>
                                            <th>Debit</th>
                                            <th>Credit</th>
                                            <th>Allocation</th>
                                            <th>Refrence</th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <?php 
                                                $date = date_create($transaction->reportBankDate);
                                                ?>
                                                <td><?php echo e(date_format($date,"M d, Y")); ?></td>
                                                <td><?php echo e($transaction->reportBankDescription); ?></td>
                                                <td><?php echo e($transaction->reportBankCategory); ?></td>
                                                <td><?php if($transaction->reportBankDebit): ?><?php echo e(auth()->user()->company->companyCurrency.''.$transaction->reportBankDebit); ?><?php else: ?> - <?php endif; ?></td>
                                                <td><?php if($transaction->reportBankCredit): ?><?php echo e(auth()->user()->company->companyCurrency.''.$transaction->reportBankCredit); ?><?php else: ?> - <?php endif; ?></td>
                                                <td><?php echo e($transaction->reportBankAllocation); ?></td>
                                                <td>
                                              

                                                   
                                                    
                                                    
                                                   
                                                    
                                                    
                                                   <?php echo $transaction->reportBankRefrence; ?></td>
                                                <td>
                                                    <div class="btn-dropdown mr-1 mb-1">
                                                        <div class="btn-group dropdown actions-dropodown">
                                                            <button type="button"
                                                                class="btn btn-white px-1 py-1 dropdown-toggle waves-effect waves-light text-bold-600"
                                                                data-toggle="dropdown" aria-haspopup="true"
                                                                aria-expanded="false">
                                                                
                                                            </button>
                                                            <div class="dropdown-menu">
                                                           
                                                                <!-- <a class="dropdown-item" href="#"><i
                                                                        class="feather icon-file"></i>Archive</a> -->
                                                                        <!-- <a class="dropdown-item" href="javascript:void(0)"  data-toggle="modal" data-backdrop="false" data-target="#detailbank"
                                                                        >edit</a> -->

                                                                    
                                                                    <?php if($transaction->reportBankDetail): ?>
                                                                    <a class="dropdown-item" href="javascript:void(0)"   onclick="getBankDetails('<?php echo e($transaction->reportBankId); ?>')" data-toggle="modal" data-backdrop="false" data-target="#detailbank"
                                                                        >Details</a>
                                                                       
                                                                      <?php endif; ?>
                                                              
                                                                    
                                                            </div>
                                                        </div>
                                                    
                                                    <div class="modal fade mt-3" id="editbank<?php echo e($transaction->reportBankId); ?>" tabindex="-1" role="dialog" aria-labelledby="myModalLabel1" aria-hidden="true">
                                                        <div class="modal-dialog modal-dialog-scrollable" role="document">
                                                            <div class="modal-content">
                                                                <form action="<?php echo e(route('update-transaction', $transaction->reportBankId)); ?>" method="POST">
                                                                    <?php echo csrf_field(); ?>
                                                                <div class="modal-header">
                                                                    <h4 class="modal-title" id="myModalLabel1">Detail</h4>
                                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                        <span aria-hidden="true">&times;</span>
                                                                    </button>
                                                                </div>
                                                                <div class="modal-body">
                                                                    <div class="row">
                                                                        <div class="col-md-12 mb-1">
                                                                            <label>Category</label>
                                                                            <select name="reportBankCategory" class="form-control" >
                                                                           
                                                                                <?php $__currentLoopData = $categoryArray; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ca): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                <option value="<?php echo e($ca); ?>" <?php if($transaction->reportBankCategory == $ca): ?> selected <?php endif; ?>><?php echo e($ca); ?></option>
                                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                            </select>
                                                                        </div>
                                                                        <div class="col-md-12 mb-1">
                                                                            <label>Allocation</label>
                                                                            <input type="text" name="reportBankAllocation" required class="form-control" value="<?php echo e($transaction->reportBankAllocation); ?>" />
                                                                        </div>
                                                                        <div class="col-md-12 mb-1">
                                                                            <label>Refrence</label>
                                                                            <input type="text" name="reportBankRefrence" required class="form-control" value="<?php echo e($transaction->reportBankRefrence); ?>" />
                                                                        </div>
                                                                        <div class="col-md-12">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="modal-footer">
                                                                    <button type="submit" class="btn btn-primary" >update</button>
                                                                </div>
                                                             </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <th>Date</th>
                                            <th>Description</th>
                                            <th>Category</th>
                                            <th>Debit</th>
                                            <th>Credit</th>
                                            <th>Allocation</th>
                                            <th>Refrence</th>
                                            <th></th>
                                        </tr>
                                    </tfoot>
                                </table>
                                <?php echo e($transactions->appends(request()->input())->links('pagination::bootstrap-4')); ?>


                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('after-scripts'); ?>
    <script>
         $("#selected_bank").change(function() {
     this.form.submit();
});



function getBankDetails(reportBankId){




$.ajaxSetup({
headers: {
  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
}

});

$.ajax({
type: "GET",
url: '/reporting/banks/detail/'+reportBankId,
beforeSend: function() {
  
  $("#detail-invoices").empty();
  $("#detail-invoices").text('loading...');

},
success: function(data) {
 
$("#detail-invoices").empty();
$("#detail-invoices").html(data);
$("#modal-footer-detail").empty();
$('#modal-footer-detail').html(`<button type="button" class="btn btn-danger" onclick="deleteTransaction(${reportBankId})">Delete Transaction</button>`)

$("#code-input").empty();


}
});
}


const deleteTransaction = (reportBankId) => {
    $("#modal-footer-detail").empty();

    $('#code-input').html(` <h4>To confirm the deletion of this transaction, please type "DELETE". Please note that this action is irreversible. </h4>
                            <input type="text" id="code" onpaste="return false;" autocomplete="off" />
                            <input type="button" value="Confirm" class="btn btn-danger btn-sm" onclick="verifyCode(${reportBankId})"/>`)
    
}

const verifyCode = (reportBankId) => {
    
   
  var codeInput = $("#code").val();
  if (codeInput === "DELETE") {
    // Code is correct, proceed with delete action
   
    $.ajax({
                url: '/reporting/bank/delete-transaction/' + reportBankId,
                type: 'DELETE',
                data: {
                    _token: $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    window.location.reload()
                    
                },
                error: function(xhr) {
                    console.log(xhr.responseText);
                }
            });
    // perform delete action here
  } else {
    // Code is incorrect, show error message
    alert("Incorrect code. Please try again.");
  }
  codeInput = ""; // Clear input field

}



    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home3/itdevic1/public_html/erpreporting/resources/views/banks/transactions.blade.php ENDPATH**/ ?>