<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
    <!-- CSRF Token -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.3/xlsx.full.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/FileSaver.js/2.0.5/FileSaver.min.js"></script>

    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title>Invoice Register</title>

   
    <style type="text/css">
      th,td{
            font-size: 9px;
            text-align: center;
  
      }
      .th1{
        background: #2543c1db;
      color: #fff;
          border: 1px solid;
  
      }
      .th2{
            background:#086504;
      color: #fff;
          border: 1px solid;
  
      }
       .th3{
            background: #b5651d;
      color: #fff;
          border: 1px solid;
  
      }
      .tdlightblue {
      background: lightblue;
          border: 1px solid;
          border-top: 1px dotted #c3b3b3 !important;
      border-bottom: 1px dotted #af9292 !important;
  
  }
  
      .tdblue {
      background: #1c992ad6;
      color: #fff;
          border: 1px solid #333;
          border-top: 1px dotted #c3b3b3 !important;
      border-bottom: 1px dotted #af9292 !important;
  
  }
  
     .tdstate {
  
     
          font-weight: bold;
          border-top: 1px dotted #c3b3b3 !important;
      border-bottom: 1px dotted #af9292 !important;
  
  }
  
  .tdlightgreen{
        background: lightgreen;
      border: 1px solid;
      border-top: 1px dotted #c3b3b3 !important;
      border-bottom: 1px dotted #af9292 !important;
  }
  .tdlightbrown{
        background: #e8720878;
      border: 1px solid;
      border-top: 1px dotted #c3b3b3 !important;
      border-bottom: 1px dotted #af9292 !important;
  }
  
  .tabfedex{
          background: #ffc1075e;
      border: 1px solid;
      border-top: 1px dotted #c3b3b3 !important;
      border-bottom: 1px dotted #af9292 !important;
  }
  input {margin-bottom: 5px; padding: 2px 3px; width: 209px !important; 
  }
  
    </style>
</head>
<body>
  <nav class="navbar navbar-light bg-light">
    <div class="container-fluid">
      <a class="navbar-brand" href="<?php echo e(route('reporting-dashboard')); ?>" style="text-decoration: revert;"><b>Dashboard</b></a>
      <form method="GET" action="" style="display:none;"> 
        <div class="row ">

       
      
          
          <div class="col-1">
            <span style="margin-top: 7px;
            position: absolute;
            margin-left: -6px;
            font-weight: bold;"><?php echo e(auth()->user()->company->companyPrefix); ?> </span>
          </div>
            <div class="col-5">
              <input type="text" name="sonumber" class="form-control" value="<?php echo e(request()->get('sonumber')); ?>">
                </div>
                
            <div class="col-4">
                <button type="submit" class="btn btn-primary waves-effect waves-light">Show</button>
                   <?php if(request()->get('sonumber')): ?>

                <a href="<?php echo e(route('invoice-register-sheet')); ?>" class="waves-effect waves-light">Reset</a>
                <?php endif; ?>
            </div>
            <div class="col-2">
               

            </div>
        </div>
        </form>

      <form method="GET" action="" id="getdata"> 
        <div class="row ">

       
      
      
            <div class="col-5">
                <?php if(!request()->get('sonumber')): ?>
                <fieldset class="form-group">
                    <select class="form-control" name="dealMonth" id="dealMonth">
                        <!-- <option value="all" selected="">All</option> -->
                <option value="all" <?php if($dealMonth == 'all'): ?> selected=""  <?php endif; ?> >All</option>

                        <?php $__currentLoopData = $dealMonthArray; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $dm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      

                    <option value="<?php echo e($key); ?>" <?php if($dealMonth == $key): ?> selected=""  <?php endif; ?> ><?php echo e($dm); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </fieldset>
                <?php endif; ?>
                </div>
                <div class="col-4">
                    <?php if(!request()->get('sonumber')): ?>
                <fieldset class="form-group">
                    <select class="form-control" name="dealYear" id="dealYear">
                    <?php $__currentLoopData = $dealYearArray; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $dy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($key); ?>" <?php if($dealYear == $key): ?> selected="" <?php elseif($key == date("y")): ?> selected="" <?php endif; ?> ><?php echo e($dy); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </fieldset>
  <?php endif; ?>
            </div>
            <div class="col-3">
                <?php if(!request()->get('sonumber')): ?>
                <button type="submit" class="btn btn-primary waves-effect waves-light">Show</button>
                  <?php endif; ?>
            </div>
        </div>
        </form>
    </div>
  </nav>
    <div id="app" >

      <h1 style="    text-align: center;
      padding-top: 18px;
      padding-bottom: 10px;">Invoice Register</h1>
      <p id="month-progess" style="    text-align: center;"></p>
<?php


$companyPrefix = auth()->user()->company->companyPrefix; 
?>
   <button id="downloadExcel" style="display: none;">Download Excel</button>

<table class="table table-responsive-xl" id="myTableExcel">
    <thead>
      <tr>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
        <th id="gross-sale">$0</th>
        
        <th id="sale-frieght">$0</th>
        <th id="sale-tax">$0</th>
        <th id="order-total">$0</th>
        
      
       
      </tr>
      <tr>
        <th class="th1">MONTH</th>
        <th class="th1">ORDER SOURCE</th>
       
     
        <th class="th1">INVOICE NO.</th>
        <th class="th1">INVOICE DATE</th>
        <th class="th1">P.O. NO. / REF. NO.</th>
        <th class="th1">CUSTOMER</th>
        <th class="th1">STATE</th>
        <th class="th1">GROSS SALE AMOUNT</th>
        
        <th class="th1">FREIGHT</th>
        <th class="th1">TAX</th>
        <th class="th1"> ORDER TOTAL</th>
        
    
    
   
    
      </tr>
    </thead>
    <tbody id="myTable">
           


               </tbody>
  </table>
        
        
    </div>
    <script type="text/javascript">
var ajaxCallCounter = 0;
var indexKey = 0;
const months = [
  "January", 
  "February", 
  "March", 
  "April", 
  "May", 
  "June", 
  "July", 
  "August", 
  "September", 
  "October", 
  "November", 
  "December"
];



$(document).ready(function(){
    $('#getdata').on('submit', function(event) {
        event.preventDefault();
 $("#myTable").empty();
  $('#downloadExcel').hide()
        var dealMonth = $('#dealMonth').val();
    

        if (dealMonth === 'all') {
            // User selected "All" for dealMonth
            //loadregister(dealYear); // Pass the year only

             ajaxCallCounter = 1;
              $('#month-progess').text(`Loading ${months[0]}, please wait ...`)
              loadregister(ajaxCallCounter);

        } else {
               $('#month-progess').text('Loading please wait...')
             


            loadregister(dealMonth); // Pass both year and month
        }
    });
});



        function loadregister(month)
  {

        var dealYear = $('#dealYear').val();

    $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
       
            $.ajax({
                type: "GET",
                url: "<?php echo e(route('invoice-register-ajax')); ?>?dealMonth="+month+"&dealYear="+dealYear,
                beforeSend: function() {
                  
                   
                },
                success: function(data) {
                  
                    $("#myTable").append(data);
     var dealMonth = $('#dealMonth').val();
if(dealMonth == 'all'){
                ajaxCallCounter++;

if (ajaxCallCounter < 13) {
  $('#month-progess').text(`loading ${months[ajaxCallCounter-1]}, please wait ...`)
  loadregister(ajaxCallCounter)
}else{
  

  setTimeout(function() {
    $('#month-progess').text('')
    }, 5000);
  $('#downloadExcel').show()
                }
            }else{
  

  setTimeout(function() {
    $('#month-progess').text('')
    }, 5000);
   $('#downloadExcel').show()
                }

            sumthevalues()

          }
        
  })
}




const sumthevalues = () =>{

  var grosssale = 0;
$('.grosssalesmount').each(function() {

 


  var value = $(this).text();
  if (value.indexOf('-') !== -1) { // Check if the value contains "-"
    value = 0; // Set the value to 0 if it contains "-"
  } else {
    value = parseFloat(value); // Convert the value to an integer if it doesn't contain "-"
  }
  grosssale += value;


});
$('#gross-sale').text('$'+grosssale.toFixed(2))


var frieghtamount = 0;
$('.frieghtamount').each(function() {


  var value = $(this).text();
  if (value.indexOf('-') !== -1) { // Check if the value contains "-"
    value = 0; // Set the value to 0 if it contains "-"
  } else {
    value = parseFloat(value); // Convert the value to an integer if it doesn't contain "-"
  }
  frieghtamount += value;


});
$('#sale-frieght').text('$'+frieghtamount.toFixed(2))


var salestaxth = 0;
$('.salestaxth').each(function() {


  var value = $(this).text();
  if (value.indexOf('-') !== -1) { // Check if the value contains "-"
    value = 0; // Set the value to 0 if it contains "-"
  } else {
    value = parseFloat(value); // Convert the value to an integer if it doesn't contain "-"
  }
  salestaxth += value;


});
$('#sale-tax').text('$'+salestaxth.toFixed(2))



var salestaxth = 0;
$('.salestaxth').each(function() {


  var value = $(this).text();
  if (value.indexOf('-') !== -1) { // Check if the value contains "-"
    value = 0; // Set the value to 0 if it contains "-"
  } else {
    value = parseFloat(value); // Convert the value to an integer if it doesn't contain "-"
  }
  salestaxth += value;


});
$('#sale-tax').text('$'+salestaxth.toFixed(2))




var grosssale = 0;
$('.grosssale').each(function() {


  var value = $(this).text();
  if (value.indexOf('-') !== -1) { // Check if the value contains "-"
    value = 0; // Set the value to 0 if it contains "-"
  } else {
    value = parseFloat(value); // Convert the value to an integer if it doesn't contain "-"
  }
  grosssale += value;


});
$('#order-total').text('$'+grosssale.toFixed(2))


var cccharges = 0;
$('.cccharges').each(function() {


  var value = $(this).text();
  if (value.indexOf('-') !== -1) { // Check if the value contains "-"
    value = 0; // Set the value to 0 if it contains "-"
  } else {
    value = parseFloat(value); // Convert the value to an integer if it doesn't contain "-"
  }
  cccharges += value;


});
$('#cc-charges').text('$'+cccharges.toFixed(2))



var netamount = 0;
$('.netamount').each(function() {


  var value = $(this).text();
  if (value.indexOf('-') !== -1) { // Check if the value contains "-"
    value = 0; // Set the value to 0 if it contains "-"
  } else {
    value = parseFloat(value); // Convert the value to an integer if it doesn't contain "-"
  }
  netamount += value;


});
$('#net-amount').text('$'+netamount.toFixed(2))



var pototalamount = 0;
$('.pototalamount').each(function() {


  var value = $(this).text();
  if (value.indexOf('-') !== -1) { // Check if the value contains "-"
    value = 0; // Set the value to 0 if it contains "-"
  } else {
    value = parseFloat(value); // Convert the value to an integer if it doesn't contain "-"
  }
  pototalamount += value;


});
$('#po-total-amount').text('$'+pototalamount.toFixed(2))


var grossprofit = 0;
$('.grossprofit').each(function() {


  var value = $(this).text();
  if (value.indexOf('-') !== -1) { // Check if the value contains "-"
    value = 0; // Set the value to 0 if it contains "-"
  } else {
    value = parseFloat(value); // Convert the value to an integer if it doesn't contain "-"
  }
  grossprofit += value;


});
$('#gross-profit').text('$'+grossprofit.toFixed(2))

        

}

    </script>
   

<script>
document.getElementById('downloadExcel').addEventListener('click', function() {
    var table = document.getElementById('myTableExcel'); // Replace 'myTable' with your table ID

    var wb = XLSX.utils.table_to_book(table, { sheet: "Sheet JS" });
    var wbout = XLSX.write(wb, { bookType: 'xlsx', type: 'array' });

    saveAs(new Blob([wbout], { type: 'application/octet-stream' }), 'table_data.xlsx');
});
</script>



</body>
</html>
<?php /**PATH /home3/itdevic1/public_html/erpreporting/resources/views/reports/invoice-register-sheet.blade.php ENDPATH**/ ?>