<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Lookup One</title>
    <link rel='stylesheet' href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css" type='text/css'
        media='all' />
    <link rel='stylesheet' href="https://cdn.datatables.net/1.10.19/css/dataTables.jqueryui.min.css" type='text/css'
        media='all' />
    <link rel='stylesheet' href="https://cdn.datatables.net/buttons/1.5.2/css/buttons.jqueryui.min.css" type='text/css'
        media='all' />
    <link rel='stylesheet' href="https://cdn.datatables.net/1.10.21/css/jquery.dataTables.min.css" type='text/css'
        media='all' />
    <link rel='stylesheet' href="https://cdn.datatables.net/responsive/2.2.5/css/responsive.dataTables.min.css"
        type='text/css' media='all' />


</head>

<body>

    <h3>LOOKUP #1 - Tab# <?php echo e($tab); ?></h3><br>

    <table id="example" class="display nowrap" style="width:100%">
        <thead>
            <tr>
                <th>SO#</th>
                <th>Company</th>
               
                <th>Billing Email</th>
                <th>Billing Phone</th>
                <th>Shipping Email</th>
                <th>Shipping Phone</th>
                <th>Amount</th>
                <th></th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $salesOrders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td>1000<?php echo e($order->dealSO); ?></td>
                <td><?php echo e($order->dealCompanyName); ?></td>

                <td><?php echo e($order->dealEmail); ?></td>
                <td><?php echo e($order->dealPhone); ?></td>
                <td><?php echo e($order->dealShippingEmail); ?></td>
                <td><?php echo e($order->dealShippingPhone); ?></td>
                <?php
                $subtotal = 0;
                foreach($order->dealItems as $item):
                $subtotal += $item->dealItemQuantity*$item->dealItemUnitCost;

                endforeach;

                $dealTaxValue = $order->dealTaxValue ? $order->dealTaxValue:0;
                $dealCreditCardCharges = $order->dealCreditCardCharges ? $order->dealCreditCardCharges:0;
                $dealShippingCharges = $order->dealShippingCharges ? $order->dealShippingCharges:0;
                $dealChargeAmount = $order->dealChargeAmount ? $order->dealChargeAmount:0;
                ?>
                <td><b>$<?php echo e((double)$subtotal+(double)$dealTaxValue+(double)$dealCreditCardCharges+(double)$dealShippingCharges+(double)$dealChargeAmount); ?></b>
                </td>
                <td> <a href="https://erp.mushahmad.com/admin/salesorder/view_salesorder/<?php echo e($order->dealSO); ?>"
                        target="_blank">view</a>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </tbody>

    </table>
</body>
<script src="https://code.jquery.com/jquery-3.5.1.js"></script>
<script src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.10.19/js/dataTables.jqueryui.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.5.2/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.5.2/js/buttons.jqueryui.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/1.5.2/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.5.2/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.5.2/js/buttons.colVis.min.js"></script>
<script src="https://cdn.datatables.net/responsive/2.2.5/js/dataTables.responsive.min.js"></script>
<script>
    $(document).ready(function() {
    var table = $('#example').DataTable( {
        lengthChange: false,
        buttons: [ 'copy', 'excel', 'pdf', 'colvis' ],
      responsive: {
            details: {
                renderer: function ( api, rowIdx, columns ) {
                    var data = $.map( columns, function ( col, i ) {
                        return col.hidden ?
                            '<tr data-dt-row="'+col.rowIndex+'" data-dt-column="'+col.columnIndex+'">'+
                                '<td>'+col.title+':'+'</td> '+
                                '<td>'+col.data+'</td>'+
                            '</tr>' :
                            '';
                    } ).join('');
 
                    return data ?
                        $('<table/>').append( data ) :
                        false;
                }
            }
        }
    } );
 
    table.buttons().container()
        .insertBefore( '#example_filter' );
} )
</script>

</html><?php /**PATH /home/mush/public_html/reporting/resources/views/look-up/one.blade.php ENDPATH**/ ?>