<?php $__env->startSection('leftbar-orders-active', 'active'); ?>

<?php $__env->startSection('breadcrumbs'); ?>
    <div class="content-header-left col-md-9 col-12 mb-2">
        <div class="row breadcrumbs-top">
            <div class="col-12">
                <h2 class="content-header-title float-left mb-0">Bank Transactions</h2>
               

            </div>
        </div>
    </div>
 
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content-body'); ?>
<?php

$categoryArray = ["", "LOAN", "LOAN RETURN"];

?>
<div class="content-body">
    <section id="sale-order-datatable">
        <div class="modal fade mt-3" id="detailbank" tabindex="-1" role="dialog" aria-labelledby="myModalLabel1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-scrollable modal-lg" role="document">
                <div class="modal-content">
                  
                    <div class="modal-header">
                        <h4 class="modal-title" id="myModalLabel1"></h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="table-responsive" >
                            <table class="table zero-configuration">
    
                            
                                <tbody id="detail-invoices">
        
        
                            </table>
                        </div>
                        <div id="code-input" class="text-center">
                           
                        </div>
                        <div class="modal-footer" id="modal-footer-detail">
                        </div>
                    </div>
                    
                </div>
            </div>
        </div>
      
        <div class="row">
            <div class="col-12">

                <div class="card m0">
                    <div class="card-content">
                        <div class="card-body">
                            <?php echo $__env->make('loans.summary', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                    </div>
                </div>
           
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title"><?php echo e($user->loanUserFirstName); ?></h4>
                    </div>
                    <div class="card-content">
                        <div class="card-body card-dashboard">
                            <div class="table-responsive">
                                <table class="table zero-configuration">
                                    <thead>
                                        <tr>
                                            <th>Date</th>
                                            <th>Description</th>
                                            <th>Category</th>
                                            <th>Amount</th>
                                            <th>Allocation</th>
                                           
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                           $companyCurrency = auth()->user()->company->companyCurrency;
                                            ?>
                                        <?php $__currentLoopData = $loans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                            <tr>
                                                <?php 
                                                $date = date_create($transaction->loanDate);
                                                ?>
                                                <td><?php echo e(date_format($date,"M d,Y")); ?></td>
                                                <td><?php echo e($transaction->loanDescription); ?></td>
                                                <td><?php echo e($categoryArray[$transaction->loanCategory]); ?></td>
                                                <td><?php if($transaction->loanTotalAmount): ?><?php echo e($companyCurrency.''.$transaction->loanTotalAmount); ?><?php else: ?> - <?php endif; ?></td>
                                                <td><?php echo e($transaction->loanCategoryType); ?></td>
                                             
                                                <td>
                                                   

                                                    <div class="btn-dropdown mr-1 mb-1">
                                                        <div class="btn-group dropdown actions-dropodown">
                                                            <button type="button"
                                                                class="btn btn-white px-1 py-1 dropdown-toggle waves-effect waves-light text-bold-600"
                                                                data-toggle="dropdown" aria-haspopup="true"
                                                                aria-expanded="false">
                                                                
                                                            </button>
                                                            <div class="dropdown-menu">
                                                           
                                                          
                                                           
                                                                    <a class="dropdown-item" href="javascript:void(0)" onclick="getBankDetails(<?php echo e($transaction->loanId); ?>)" data-toggle="modal" data-backdrop="false" data-target="#detailbank"
                                                                        >Details</a>
                                                                       
                                                                       
                                                            </div>

                                                    <div class="modal fade mt-3" id="editbank<?php echo e($transaction->loanId); ?>" tabindex="-1" role="dialog" aria-labelledby="myModalLabel1" aria-hidden="true">
                                                        <div class="modal-dialog modal-dialog-scrollable" role="document">
                                                            <div class="modal-content">
                                                                <form action="" method="POST">
                                                                    <?php echo csrf_field(); ?>
                                                                <div class="modal-header">
                                                                    <h4 class="modal-title" id="myModalLabel1">Detail</h4>
                                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                        <span aria-hidden="true">&times;</span>
                                                                    </button>
                                                                </div>
                                                                <div class="modal-body">
                                                                    <div class="row">
                                                                        <div class="col-md-12 mb-1">
                                                                            <label>Category</label>
                                                                            <select name="reportingccCategory" class="form-control" >
                                                                           
                                                                                <?php $__currentLoopData = $categoryArray; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ca): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                <option value="<?php echo e($ca); ?>" <?php if($transaction->reportingccCategory == $ca): ?> selected <?php endif; ?>><?php echo e($ca); ?></option>
                                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                            </select>
                                                                        </div>
                                                                        <div class="col-md-12 mb-1">
                                                                            <label>Allocation</label>
                                                                            <input type="text" name="reportingccAllocation" required class="form-control" value="<?php echo e($transaction->reportingccAllocation); ?>" />
                                                                        </div>
                                                                        <div class="col-md-12 mb-1">
                                                                            <label>Refrence</label>
                                                                            <input type="text" name="reportingccRefrence" required class="form-control" value="<?php echo e($transaction->reportingccReference); ?>" />
                                                                        </div>
                                                                        <div class="col-md-12">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="modal-footer">
                                                                    <button type="submit" class="btn btn-primary" >update</button>
                                                                </div>
                                                             </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                
                                </table>
                                <?php echo e($loans->appends(request()->input())->links('pagination::bootstrap-4')); ?>


                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('after-scripts'); ?>
    <script>
         $("#selected_bank").change(function() {
     this.form.submit();
});



function getBankDetails(reportCardId){



$.ajaxSetup({
headers: {
  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
}

});

$.ajax({
type: "GET", 
url: '/reporting/card/detail/'+reportCardId,
beforeSend: function() {
  
  $("#detail-invoices").empty();
  $("#detail-invoices").text('loading...');

},
success: function(data) {
 
$("#detail-invoices").empty();
$("#detail-invoices").html(data);
$("#modal-footer-detail").empty();
$('#modal-footer-detail').html(`<button type="button" class="btn btn-danger" onclick="deleteTransaction(${reportCardId})">Delete Transaction</button>`)

$("#code-input").empty();


}
});
}


const deleteTransaction = (reportBankId) => {
    $("#modal-footer-detail").empty();

    $('#code-input').html(` <h4>To confirm the deletion of this transaction, please type "DELETE". Please note that this action is irreversible. </h4>
                            <input type="text" id="code" onpaste="return false;" autocomplete="off" />
                            <input type="button" value="Confirm" class="btn btn-danger btn-sm" onclick="verifyCode(${reportBankId})"/>`)
    
}

const verifyCode = (reportBankId) => {
    
   
  var codeInput = $("#code").val();
  if (codeInput === "DELETE") {
    // Code is correct, proceed with delete action
   
    $.ajax({
                url: '/reporting/card/delete-transaction/' + reportBankId,
                type: 'DELETE',
                data: {
                    _token: $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    window.location.reload()
                    
                },
                error: function(xhr) {
                    console.log(xhr.responseText);
                }
            });
    // perform delete action here
  } else {
    // Code is incorrect, show error message
    alert("Incorrect code. Please try again.");
  }
  codeInput = ""; // Clear input field

}



    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home3/itdevic1/public_html/erpreporting/resources/views/loans/history.blade.php ENDPATH**/ ?>