<?php $__env->startSection('leftbar-orders-active', 'active'); ?>

<?php $__env->startSection('content-body'); ?>

<div class="content-body">
    <section id="sale-order-datatable">
        

        <?php 
$tempUrl = 'https://erp.thetechit.com/admin/pdf/invoice_pdf/'

?>

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Invoices ~ <?php echo e($customer->userCompany); ?></h4>
                    </div>
                    <div class="card-content">
                        <div class="card-body card-dashboard">
                            <div class="table-responsive">
                                <table class="table zero-configuration">
                                    <thead>
                                        <tr>
                                         <th>#</th>
                                         <th>Due Date</th>   
                                         <th>subtotal</th>
                                         <th>Shipping</th>
                                         <th>Tax</th>
                                         <th>Charges</th>
                                         <th>CC Charges</th>
                                         <th>Total</th>
                                         <th>Status</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        
                                        <?php $invoiceIsReturn = $invoice->invoiceType; ?>
                                        <tr style=" <?php if($invoiceIsReturn == 'return'): ?> background:#ff000026; <?php endif; ?>">
                                        <td><a href="<?php echo e($tempUrl); ?><?php echo e($invoice->invoiceId); ?>" target="_blank"><?php echo e(auth()->user()->company->companyPrefix); ?><?php echo e($invoice->invoiceSoId); ?> - <?php echo e($invoice->invoiceSoSerial); ?></a></td>
                                        <td><?php $date=date_create($invoice->invoiceDueDate); ?> <?php echo e(date_format($date,"m/d/Y")); ?></td>
                                        <td><?php echo e(auth()->user()->company->companyCurrency); ?><?php echo e(number_format($invoice->total, 2)); ?></td>
                                        <td><?php echo e(auth()->user()->company->companyCurrency); ?><?php echo e(number_format($invoice->invoiceShippingCharges, 2)); ?></td>
                                        <td><?php echo e(auth()->user()->company->companyCurrency); ?><?php echo e(number_format($invoice->invoiceTaxValue, 2)); ?></td>
                                        <td><?php echo e(auth()->user()->company->companyCurrency); ?><?php echo e(number_format($invoice->invoiceChargeAmount, 2)); ?></td>
                                        <td><?php echo e(auth()->user()->company->companyCurrency); ?><?php echo e(number_format($invoice->invoiceCreditCardCharges, 2)); ?></td>
                                        <td><?php echo e(auth()->user()->company->companyCurrency); ?><?php echo e(number_format( +$invoice->total + $invoice->invoiceShippingCharges + $invoice->invoiceTaxValue + $invoice->invoiceChargeAmount +$invoice->invoiceCreditCardCharges, 2)); ?> </td>
                                        <td><?php echo $__env->make('reporting.receivables.partials.status', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <th>#</th>
                                            <th>Date</th>   
                                            <th>subtotal</th>
                                            <th>Shipping</th>
                                            <th>Tax</th>
                                            <th>Charges</th>
                                            <th>CC Charges</th>
                                            <th>Total</th>
                                            <th>Status</th>

                                           </tr>
                                    </tfoot>
                                </table>
                                <?php echo e($invoices->links('pagination::bootstrap-4')); ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('after-scripts'); ?>
    <script>
        $('#sale-order-datatable').DataTable();
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home3/itdevic1/public_html/erpreporting/resources/views/reporting/receivables/invoices.blade.php ENDPATH**/ ?>