<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
    <!-- CSRF Token -->
    <script src="https://cdn.jsdelivr.net/npm/jquery@3.6.3/dist/jquery.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert.min.css">

    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title>Audit Report</title>

   
    <style type="text/css">
      th,td{
            font-size: 9px;
            text-align: center;
  
      }
      .th1{
        background: #2543c1db;
      color: #fff;
          border: 1px solid;
  
      }
      .th2{
            background:#086504;
      color: #fff;
          border: 1px solid;
  
      }
       .th3{
            background: #b5651d;
      color: #fff;
          border: 1px solid;
  
      }
      .tdlightblue {
      background: lightblue;
          border: 1px solid;
          border-top: 1px dotted #c3b3b3 !important;
      border-bottom: 1px dotted #af9292 !important;
  
  }
  
      .tdblue {
      background: #1c992ad6;
      color: #fff;
          border: 1px solid #333;
          border-top: 1px dotted #c3b3b3 !important;
      border-bottom: 1px dotted #af9292 !important;
  
  }
  
     .tdstate {
  
          border: 2px solid #333;
          color: red;
          font-weight: bold;
          border-top: 1px dotted #c3b3b3 !important;
      border-bottom: 1px dotted #af9292 !important;
  
  }
  
  .tdlightgreen{
        background: lightgreen;
      border: 1px solid;
      border-top: 1px dotted #c3b3b3 !important;
      border-bottom: 1px dotted #af9292 !important;
  }
  .tdlightbrown{
        background: #e8720878;
      border: 1px solid;
      border-top: 1px dotted #c3b3b3 !important;
      border-bottom: 1px dotted #af9292 !important;
  }
  
  .tabfedex{
          background: #ffc1075e;
      border: 1px solid;
      border-top: 1px dotted #c3b3b3 !important;
      border-bottom: 1px dotted #af9292 !important;
  }
  input {margin-bottom: 5px; padding: 2px 3px; width: 209px !important; 
  }
  
    </style>
</head>
<body>
  <nav class="navbar navbar-light bg-light">
    <div class="container-fluid">
      <a class="navbar-brand">Audit Report</a>
      <?php
        $companyPrefix = auth()->user()->company->companyPrefix;
        $companyCurrency = auth()->user()->company->companyCurrency;
      ?>
      <form method="GET" action=""> 
        <div class="row ">

       
      
          
          <div class="col-1">
            <span style="margin-top: 7px;
            position: absolute;
            margin-left: -6px;
            font-weight: bold;"><?php echo e($companyPrefix); ?> </span>
          </div>
            <div class="col-5">
              <input type="text" name="sonumber" class="form-control" value="<?php echo e(request()->get('sonumber')); ?>">
                </div>
                
            <div class="col-4">
                <button type="submit" class="btn btn-primary waves-effect waves-light">Show</button>
                <?php if(request()->get('sonumber')): ?>

                <a href="" class="waves-effect waves-light">Reset</a>
                <?php endif; ?>
            </div>
            <div class="col-2">
                
            </div>
        </div>
        </form>
      <form method="GET" action=""> 
        <div class="row ">

            <?php if(request()->get('onlysheet')): ?>
            <input type="hidden" value="<?php echo e(request()->get('onlysheet')); ?>" name="onlysheet" />
          <?php endif; ?>
            <div class="col-5">
                <fieldset class="form-group">
                    <select class="form-control" name="dealMonth" id="dealMonth">
                        <!-- <option value="all" selected="">All</option> -->
                <option value="all" <?php if($dealMonth == 'all'): ?> selected=""  <?php endif; ?> >All</option>

                        <?php $__currentLoopData = $dealMonthArray; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $dm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      

                    <option value="<?php echo e($key); ?>" <?php if($dealMonth == $key): ?> selected=""  <?php endif; ?> ><?php echo e($dm); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </fieldset>
                </div>
                <div class="col-4">
                <fieldset class="form-group">
                    <select class="form-control" name="dealYear" id="dealYear">
                    <?php $__currentLoopData = $dealYearArray; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $dy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($key); ?>" <?php if($dealYear == $key): ?> selected="" <?php elseif($key == date("y")): ?> selected="" <?php endif; ?> ><?php echo e($dy); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </fieldset>
            </div>
            <div class="col-3">
                <button type="submit" class="btn btn-primary waves-effect waves-light">Show</button>
            </div>
        </div>
        </form>
    </div>
  </nav>
    <div id="app" >

      
<?php


$salefrieght = [];
$netamount = [];

?>
   
      <table class="table table-responsive-xl">
        <thead>
          <tr>
         
            <th></th>
            <th></th>
            <th></th>
            <th></th>
            <th></th>
            <th></th>
             <th></th>
            <th ></th>
            
           
           
            <th></th>
            <th id="net-amount">$0.00</th>

            <th id="sale-frieght">$0.00</th>
            <th ></th>
            <th></th>
            <th></th>
            <th></th>
            <th></th>
        
         
       
      
          </tr>
          <tr>
            <th class="th1">INVOICE DATE</th>
            <th class="th1">ORDER SOURCE</th>
            <th class="th1">CONTRACT NO</th>
            <th class="th1">SIN</th>
          
            <th class="th1">P.O. NO.</th>
            <th class="th1">BILL TO</th>
            <th class="th1"></th>
            <th class="th1">INVOICE NO.</th>
            <th class="th1">SHIP TO</th>
           
            
           
    
            <th class="th1"> ORDER TOTAL</th>
            <th class="th1">SHIPPING INCLUDED</th>
            <th class="th2">SKU NO.</th>
            <th class="th2">UNIT PRICE</th>
            <th class="th2">UNIT QTY</th>
            <th class="th2">PRODUCT NAME</th>
     
            <th class="" style="background:#9b9b9b;">TRACKING NO.</th>
       
          </tr>
        </thead>
        <tbody id="myTable">
  
     
       
          <?php $__empty_1 = true; $__currentLoopData = $all_records; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
<?php if(!empty($record)): ?>
          <tr>
           
        <?php 

$netamount[] = $record['gross_sale'] ? $record['gross_sale'] : 0;
$salefrieght[] = $record['frieght'] ? $record['frieght'] : 0;
$single_recordthetype = $record['thetype'];
              $selctoption = $departments[$single_recordthetype] ?? null;
        ?>
            
                  <td ><?php echo e($record['invoice_date'] ? $record['invoice_date'] : '-'); ?></td>
              <td ><?php echo e($selctoption); ?></td>
              <td >-</td>
              <td ><?php echo e($record['thesin'] ? $record['thesin'] : '-'); ?></td>
              <td ><?php echo e($record['po_number'] ? $record['po_number'] : '-'); ?></td>
              <td ><?php echo e($record['bill_to'] ? $record['bill_to'] : '-'); ?></td>
              <td></td>
              <td ><?php echo e($companyPrefix); ?><?php echo e($record['invoice'] ? $record['invoice'] : '-'); ?></td>
              <td ><?php echo e($record['ship_to'] ? $record['ship_to'] : '-'); ?></td>

          
            <td class="tdlightgreen grosssale"> <?php echo e($record['gross_sale'] ? $record['gross_sale'] : '-'); ?></td>
            <td class="tdlightblue frieghtamount"> <?php echo e($record['frieght'] ? $record['frieght'] : '-'); ?></td>
            <td ><?php echo e($record['invoiceItemName'] ? $record['invoiceItemName'] : '-'); ?> </td>
            <td ><?php echo e($record['invoiceItemUnitCost'] ? $record['invoiceItemUnitCost'] : '-'); ?> </td>
            <td ><?php echo e($record['invoiceItemQuantity'] ? $record['invoiceItemQuantity'] : '-'); ?> </td>
            <td ><?php echo e($record['invoiceItemDescription'] ? $record['invoiceItemDescription'] : '-'); ?> </td>
            <td ></td>
           
          </tr>
          <?php endif; ?>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
          <?php endif; ?>
        </tbody>
      </table>
 

        
          
    </div>
   <?php
     $totalgrosssale = array_sum($netamount);
      $totalsalefrieght = array_sum($salefrieght);
   ?>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
    <script>
      $(document).ready(function(){
        $('#net-amount').text('$<?php echo e(number_format($totalgrosssale, 2)); ?>')
        $('#sale-frieght').text('$<?php echo e(number_format($totalsalefrieght, 2)); ?>')
      });

      </script>
    
 <script src="<?php echo e(asset('app-assets/vendors/js/extensions/sweetalert2.all.min.js')); ?>"></script>
 <script src="<?php echo e(asset('app-assets/js/scripts/extensions/sweet-alerts.js')); ?>"></script>
  
</body>
</html>
<?php /**PATH /home3/itdevic1/public_html/erpreporting/resources/views/reports/audit/index.blade.php ENDPATH**/ ?>